<?php

namespace NumberToWords\NumberTransformer;

class UzbekNumberTransformerTest extends NumberTransformerTest
{
    protected function setUp(): void
    {
        $this->numberTransformer = new UzbekNumberTransformer();
    }

    public function providerItConvertsNumbersToWords(): array
    {
        return [
            [-3, 'minus uch'],
            [-9539, 'minus to\'qqiz ming besh yuz o\'ttiz to\'qqiz'],
            [0, 'nol'],
            [1, 'bir'],
            [3, 'uch'],
            [8, 'sakkiz'],
            [9, 'to\'qqiz'],
            [10, 'o\'n'],
            [11, 'o\'n bir'],
            [12, 'o\'n ikki'],
            [16, 'o\'n olti'],
            [19, 'o\'n to\'qqiz'],
            [20, 'yigirma'],
            [21, 'yigirma bir'],
            [25, 'yigirma besh'],
            [26, 'yigirma olti'],
            [30, 'o\'ttiz'],
            [31, 'o\'ttiz bir'],
            [40, 'qirq'],
            [43, 'qirq uch'],
            [50, 'ellik'],
            [55, 'ellik besh'],
            [58, 'ellik sakkiz'],
            [60, 'oltmish'],
            [67, 'oltmish yetti'],
            [70, 'yetmish'],
            [79, 'yetmish to\'qqiz'],
            [80, 'sakson'],
            [81, 'sakson bir'],
            [90, 'to\'qson'],
            [99, 'to\'qson to\'qqiz'],
            [100, 'bir yuz'],
            [101, 'bir yuz bir'],
            [102, 'bir yuz ikki'],
            [111, 'bir yuz o\'n bir'],
            [113, 'bir yuz o\'n uch'],
            [120, 'bir yuz yigirma'],
            [121, 'bir yuz yigirma bir'],
            [188, 'bir yuz sakson sakkiz'],
            [203, 'ikki yuz uch'],
            [227, 'ikki yuz yigirma yetti'],
            [287, 'ikki yuz sakson yetti'],
            [300, 'uch yuz'],
            [356, 'uch yuz ellik olti'],
            [410, 'to\'rt yuz o\'n'],
            [434, 'to\'rt yuz o\'ttiz to\'rt'],
            [500, 'besh yuz'],
            [578, 'besh yuz yetmish sakkiz'],
            [660, 'olti yuz oltmish'],
            [666, 'olti yuz oltmish olti'],
            [689, 'olti yuz sakson to\'qqiz'],
            [729, 'yetti yuz yigirma to\'qqiz'],
            [894, 'sakkiz yuz to\'qson to\'rt'],
            [900, 'to\'qqiz yuz'],
            [909, 'to\'qqiz yuz to\'qqiz'],
            [919, 'to\'qqiz yuz o\'n to\'qqiz'],
            [990, 'to\'qqiz yuz to\'qson'],
            [999, 'to\'qqiz yuz to\'qson to\'qqiz'],
            [1000, 'bir ming'],
            [1001, 'bir ming bir'],
            [1010, 'bir ming o\'n'],
            [1015, 'bir ming o\'n besh'],
            [1097, 'bir ming to\'qson yetti'],
            [1100, 'bir ming bir yuz'],
            [1104, 'bir ming bir yuz to\'rt'],
            [1111, 'bir ming bir yuz o\'n bir'],
            [1243, 'bir ming ikki yuz qirq uch'],
            [2000, 'ikki ming'],
            [2385, 'ikki ming uch yuz sakson besh'],
            [3766, 'uch ming yetti yuz oltmish olti'],
            [4000, 'to\'rt ming'],
            [4196, 'to\'rt ming bir yuz to\'qson olti'],
            [4538, 'to\'rt ming besh yuz o\'ttiz sakkiz'],
            [5000, 'besh ming'],
            [5020, 'besh ming yigirma'],
            [5846, 'besh ming sakkiz yuz qirq olti'],
            [6459, 'olti ming to\'rt yuz ellik to\'qqiz'],
            [7232, 'yetti ming ikki yuz o\'ttiz ikki'],
            [8569, 'sakkiz ming besh yuz oltmish to\'qqiz'],
            [9539, 'to\'qqiz ming besh yuz o\'ttiz to\'qqiz'],
            [11000, 'o\'n bir ming'],
            [11001, 'o\'n bir ming bir'],
            [21000, 'yigirma bir ming'],
            [21512, 'yigirma bir ming besh yuz o\'n ikki'],
            [90000, 'to\'qson ming'],
            [92100, 'to\'qson ikki ming bir yuz'],
            [212112, 'ikki yuz o\'n ikki ming bir yuz o\'n ikki'],
            [720018, 'yetti yuz yigirma ming o\'n sakkiz'],
            [999000, 'to\'qqiz yuz to\'qson to\'qqiz ming'],
            [999999, 'to\'qqiz yuz to\'qson to\'qqiz ming to\'qqiz yuz to\'qson to\'qqiz'],
            [1000000, 'bir million'],
            [1001001, 'bir million bir ming bir'],
            [2000000, 'ikki million'],
            [3248518, 'uch million ikki yuz qirq sakkiz ming besh yuz o\'n sakkiz'],
            [4000000, 'to\'rt million'],
            [5000000, 'besh million'],
            [999000000, 'to\'qqiz yuz to\'qson to\'qqiz million'],
            [999000999, 'to\'qqiz yuz to\'qson to\'qqiz million to\'qqiz yuz to\'qson to\'qqiz'],
            [999999000, 'to\'qqiz yuz to\'qson to\'qqiz million to\'qqiz yuz to\'qson to\'qqiz ming'],
            [999999999, 'to\'qqiz yuz to\'qson to\'qqiz million to\'qqiz yuz to\'qson to\'qqiz ming to\'qqiz yuz to\'qson to\'qqiz'],
            [1174315110, 'bir milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming bir yuz o\'n'],
            [1174315119, 'bir milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming bir yuz o\'n to\'qqiz'],
            [1800000006, 'bir milliard sakkiz yuz million olti'],
            [15174315119, 'o\'n besh milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming bir yuz o\'n to\'qqiz'],
            [35174315119, 'o\'ttiz besh milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming bir yuz o\'n to\'qqiz'],
            [935174315119, 'to\'qqiz yuz o\'ttiz besh milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming bir yuz o\'n to\'qqiz'],
            [2935174315642, 'ikki trillion to\'qqiz yuz o\'ttiz besh milliard bir yuz yetmish to\'rt million uch yuz o\'n besh ming olti yuz qirq ikki']
        ];
    }
}
