@extends('layouts.master')
@section('content')
    <div class="group-data-[sidebar-size=lg]:ltr:md:ml-vertical-menu group-data-[sidebar-size=lg]:rtl:md:mr-vertical-menu group-data-[sidebar-size=md]:ltr:ml-vertical-menu-md group-data-[sidebar-size=md]:rtl:mr-vertical-menu-md group-data-[sidebar-size=sm]:ltr:ml-vertical-menu-sm group-data-[sidebar-size=sm]:rtl:mr-vertical-menu-sm pt-[calc(theme('spacing.header')_*_1)] pb-[calc(theme('spacing.header')_*_0.8)] px-4 group-data-[navbar=bordered]:pt-[calc(theme('spacing.header')_*_1.3)] group-data-[navbar=hidden]:pt-0 group-data-[layout=horizontal]:mx-auto group-data-[layout=horizontal]:max-w-screen-2xl group-data-[layout=horizontal]:px-0 group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:ltr:md:ml-auto group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:rtl:md:mr-auto group-data-[layout=horizontal]:md:pt-[calc(theme('spacing.header')_*_1.6)] group-data-[layout=horizontal]:px-3 group-data-[layout=horizontal]:group-data-[navbar=hidden]:pt-[calc(theme('spacing.header')_*_0.9)]">
            <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">

                <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
                    <div class="grow">
                        <h5 class="text-16">Analytics</h5>
                    </div>
                    <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                        <li class="relative before:content-['\ea54'] before:font-remix ltr:before:-right-1 rtl:before:-left-1  before:absolute before:text-[18px] before:-top-[3px] ltr:pr-4 rtl:pl-4 before:text-slate-400 dark:text-zink-200">
                            <a href="#!" class="text-slate-400 dark:text-zink-200">Dashboards</a>
                        </li>
                        <li class="text-slate-700 dark:text-zink-100">
                            Analytics
                        </li>
                    </ul>
                </div>
                <div class="grid grid-cols-12 gap-x-5">
                    <div class="order-1 md:col-span-6 lg:col-span-3 col-span-12 2xl:order-1 bg-green-100 dark:bg-green-500/20 card 2xl:col-span-2 group-data-[skin=bordered]:border-green-500/20 relative overflow-hidden">
                        <div class="card-body">
                            <i data-lucide="kanban" class="absolute top-0 stroke-1 size-32 text-green-200/50 dark:text-green-500/20 ltr:-right-10 rtl:-left-10"></i>
                            <div class="flex items-center justify-center bg-green-500 rounded-md size-12 text-15 text-green-50">
                                <i data-lucide="users"></i>
                            </div>
                            <h5 class="mt-5 mb-2"><span class="counter-value" data-target="{{$t_all}}"></span></h5>
                            <p class="text-slate-500 dark:text-slate-200">Total Peserta</p>
                        </div>
                    </div><!--end col-->
                    <div class="order-2 md:col-span-6 lg:col-span-3 col-span-12 2xl:order-1 bg-orange-100 dark:bg-orange-500/20 card 2xl:col-span-2 group-data-[skin=bordered]:border-orange-500/20 relative overflow-hidden">
                        <div class="card-body">
                            <i data-lucide="list-filter" class="absolute top-0 stroke-1 size-32 text-orange-200/50 dark:text-orange-500/20 ltr:-right-10 rtl:-left-10"></i>
                            <div class="flex items-center justify-center bg-orange-500 rounded-md size-12 text-15 text-orange-50">
                                <i data-lucide="user-round-plus"></i>
                            </div>
                            <h5 class="mt-5 mb-2"><span class="counter-value" data-target="{{$t_peserta}}"></span></h5>
                            <p class="text-slate-500 dark:text-slate-200">Total peserta Paid</p>
                        </div>
                    </div><!--end col-->

                    <div class="order-3 md:col-span-6 lg:col-span-3 col-span-12 2xl:order-1 bg-red-100 dark:bg-red-500/20 card 2xl:col-span-2 group-data-[skin=bordered]:border-sky-500/20 relative overflow-hidden">
                        <div class="card-body">
                            <i data-lucide="list-filter" class="absolute top-0 stroke-1 size-32 text-sky-200/50 dark:text-sky-500/20 ltr:-right-10 rtl:-left-10"></i>
                            <div class="flex items-center justify-center rounded-md size-12 bg-sky-500 text-15 text-sky-50">
                                <i data-lucide="user-cog"></i>
                            </div>
                              <h5 class="mt-5 mb-2"><span class="counter-value" data-target="{{$duplicateCount}}"></span></h5>
                            <p class="text-slate-500 dark:text-slate-200">Double Nama Peserta</p>
                        </div>
                    </div><!--end col-->
                    
                    <div class="order-4 md:col-span-6 lg:col-span-3 col-span-12 2xl:order-1 bg-sky-100 dark:bg-sky-500/20 card 2xl:col-span-2 group-data-[skin=bordered]:border-sky-500/20 relative overflow-hidden">
                        <div class="card-body">
                            <i data-lucide="list-filter" class="absolute top-0 stroke-1 size-32 text-sky-200/50 dark:text-sky-500/20 ltr:-right-10 rtl:-left-10"></i>
                            <div class="flex items-center justify-center rounded-md size-12 bg-sky-500 text-15 text-sky-50">
                                <i data-lucide="shield-ban"></i>
                            </div>
                              <h5 class="mt-5 mb-2"><span class="counter-value" data-target="{{$t_exp}}"></span></h5>
                            <p class="text-slate-500 dark:text-slate-200">Total peserta Exp</p>
                        </div>
                    </div><!--end col-->
                    <div class="order-5 md:col-span-6 lg:col-span-3 col-span-12 2xl:order-1 bg-purple-100 dark:bg-purple-500/20 card 2xl:col-span-2 group-data-[skin=bordered]:border-purple-500/20 relative overflow-hidden">
                        <div class="card-body">
                            <i data-lucide="kanban" class="absolute top-0 stroke-1 size-32 text-purple-200/50 dark:text-purple-500/20 ltr:-right-10 rtl:-left-10"></i>
                            <div class="flex items-center justify-center bg-purple-500 rounded-md size-12 text-15 text-purple-50">
                                <i data-lucide="percent"></i>
                            </div>
                            <h5 class="mt-5 mb-2"><span class="counter-value" data-target="{{$persen}}"></span>%</h5>
                            <p class="text-slate-500 dark:text-slate-200">Persentase</p>
                        </div>
                    </div><!--end col-->
                    <div class="order-6 col-span-12 2xl:order-1 card 2xl:col-span-5">
                        <div class="card-body">
                            <div class="flex items-center gap-2">
                                <h6 class="mb-3 text-15 grow">Participant Registration Chart</h6>
                              
                            </div>

                            <div id="responseTimes" class="apex-charts" data-chart-colors='["bg-red-500"]' dir="ltr"></div>
                        </div>
                    </div><!--end col-->
                   <div class="col-span-12 lg:col-span-6 order-8 2xl:order-1 card 2xl:col-span-3">
                        <div class="card-body">
                            <h6 class="mb-3 text-15">Participant age</h6>
                            <ul class="flex flex-col gap-5">
                                @foreach ($ageStats as $age)
                                    @php
                                        $icon = match($age->age_group) {
                                            'Under 11 years' => ['icon' => 'baby', 'color' => 'text-red-500 bg-red-100 dark:bg-red-500/20'],
                                            '11 to 17 years' => ['icon' => 'users-2', 'color' => 'text-sky-500 bg-sky-100 dark:bg-sky-500/20'],
                                            '18 to 44 years' => ['icon' => 'heart-handshake', 'color' => 'text-orange-500 bg-orange-100 dark:bg-orange-500/20'],
                                            default => ['icon' => 'scan-face', 'color' => 'text-green-500 bg-green-100 dark:bg-green-500/20'],
                                        };
                                    @endphp
                                    <li class="flex items-center gap-3">
                                        <div class="flex items-center justify-center {{ $icon['color'] }} rounded-md size-8 shrink-0">
                                            <i data-lucide="{{ $icon['icon'] }}" class="size-4"></i>
                                        </div>
                                        <h6 class="grow">{{ $age->age_group }}</h6>
                                        <p class="text-slate-500 dark:text-zink-200">{{ number_format($age->total) }}</p>
                                        <div class="w-12 text-green-500 ltr:text-right rtl:text-left">
                                            {{ $age->percentage }}%
                                        </div>
                                    </li>
                                @endforeach

                              
                            </ul>
                        </div>
                    </div>
                    
                    <!--end col-->
                    <div class="order-7 col-span-12 lg:col-span-6 2xl:order-1 card 2xl:col-span-4">
                        <div class="card-body">
                            <div class="flex items-center gap-2 mb-3">
                                <h6 class="text-15 grow">Target Achievement <a href="#!" data-tooltip="default" data-tooltip-content="The 1-to-5 satisfaction scale is used for measuring customer satisfaction" class="inline-block align-middle ltr:ml-1 rtl:mr-1 text-slate-500 dark:text-zink-200"><i data-lucide="info" class="size-4"></i></a></h6>
                                
                            </div>
                            <div id="satisfactionRate" class="apex-charts" data-chart-colors='["bg-custom-500"]' dir="ltr"></div>
                            <p class="text-center text-15 text-slate-500 dark:text-zink-200">Peserta</p>
                        </div>
                    </div><!--end col-->
                    <div class="order-9 col-span-12 2xl:order-1 card 2xl:col-span-4">
                        <div class="card-body">
                            <div class="flex items-center gap-2 mb-3">
                                <h6 class="text-15 grow">Daily Visit Insights (Paid) <a href="#!" data-tooltip="default" data-tooltip-content="Analyst or business user discovering a pattern in data or a relationship between variables" class="inline-block align-middle ltr:ml-1 rtl:mr-1 text-slate-500 dark:text-zink-200"><i data-lucide="info" class="size-4"></i></a></h6>
                               
                            </div>
                            <div id="dailyVisitInsightsChart"
                                class="apex-charts"
                                data-chart-colors='["#3b82f6", "#ec4899"]'
                                data-gender-series='@json($genderSeriesFormatted)'
                                data-date-labels='@json($dateLabels)'
                                dir="ltr">
                            </div>
                        </div>
                    </div><!--end col-->
                   
                  
                 
                   
                    <div class="col-span-12 lg:col-span-6 order-[14] 2xl:order-1 card 2xl:col-span-3">
                        <div class="card-body">
                            <h6 class="mb-3 text-15">Participant category</h6>
                            
                               <div id="stackedColumn100Chart" class="apex-charts" data-chart-colors='["bg-sky-500", "bg-orange-500", "bg-yellow-500","bg-custom-500","bg-green-500"]' dir="ltr"></div>
                        </div>
                    </div>
                    <div class="col-span-12 lg:col-span-6 order-[15] 2xl:order-1 card 2xl:col-span-3">
                        <div class="card-body">
                            <div class="flex items-center gap-4 mb-3">
                                <h6 class="text-15 grow">Competition category</h6>
                               
                            </div>
                            <div class="flex flex-col gap-5">
                              
                               @foreach($packages as $item)
                                <div>
                                    <div class="flex items-center justify-between gap-4 mb-2">
                                        <h6><a href="{{route('peserta/grafikDetail',[$kota,'kode' => $item['kode']])}}" target="_blank" class="text-slate-400 dark:text-zink-200">{{ $item['label'] }}</a></h6>
                                        <span class="text-slate-500 dark:text-zink-200">{{ number_format($item['count']) }}</span>
                                    </div>
                                    <div class="w-full h-3.5 rounded bg-slate-200 dark:bg-zink-600">
                                        <div class="h-3.5 rounded {{ $item['color'] }}" style="width: {{ $item['percent'] }}%"></div>
                                    </div>
                                </div>
                            @endforeach


                            </div>
                        </div>
                    </div>
                </div>
                

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->
@section('script')
 <!-- <script src="{{ URL::to('assets/libs/choices.js/public/assets/scripts/choices.min.js')}}"></script> -->
<script>
    window.responseTimesData = {
        categories: @json($categories),
        paid: @json($paid),
        unpaid: @json($unpaid)
    };
</script>
<script>
    var pencapaianPeserta = {{ $presentase_pencapaian }};
</script>
<!-- Participant category -->

<script>
    window.chartLabels = @json($labels);
    window.chartData = @json($data);
    window.chartRawCount = @json($jumlah_peserta); 
</script>
<!-- Daily Visit Insights -->

 <script src="{{ URL::to('assets/js/pages/dashboards-analytics.init.js')}}"></script>
@endsection
@endsection