<div class="group-data-[sidebar-size=lg]:ltr:md:ml-vertical-menu ...">
    <div class="container-fluid group-data-[content=boxed]:max-w-boxed mx-auto">
        <div class="flex flex-col gap-2 py-4 md:flex-row md:items-center print:hidden">
            <div class="grow">
                <h5 class="text-16">Race Pack {{ $lok }}</h5>
            </div>
            <ul class="flex items-center gap-2 text-sm font-normal shrink-0">
                <li class="relative ...">
                    <a href="#" class="text-slate-400 dark:text-zink-200">Peserta</a>
                </li>
                <li class="text-slate-700 dark:text-zink-100">
                    Daftar Peserta {{ $lok }}
                </li>
            </ul>
        </div>

        <div class="card">
            <div class="card-body">
                <h6 class="text-15 grow">Peserta </h6>
                <br>
                <table id="alternativePagination" class="display" style="width:100%">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th hidden>ID</th>
                            <th>Loket</th>
                            <th>Bib Number</th>
                            <th>Full Name</th>
                            <th>Size Jersey</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($peserta as $key => $value)
                            @php
                                $kat = match($value->package) {
                                    1 => 'Fan Walk',
                                    2 => '5K',
                                    3 => '10K',
                                    4 => 'HM',
                                    '5A' => 'Kids Dash 400M',
                                    default => 'Kids Dash 200'
                                };
                            @endphp
                            <tr>
                                <td>{{ $key + 1 }}</td>
                                <td class="id_update" hidden>{{ $value->order_id }}</td>
                                <td>Loket {{ $value->loket }}</td>
                                <td>{{ $value->bib_number }}</td>
                                <td>{{ $value->full_name }}</td>
                                <td>{{ $value->package != 'ELyx4' ? $value->tshirt_size : '-' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal example to send email (using Livewire) -->
<!-- <div>
    <button wire:click="sendEmail({{ $value->order_id }})">Send Email</button>
</div> -->
