@extends('layoutsutama.peserta')
@section('content')
        <div class="group-data-[sidebar-size=lg]:ltr:md:ml-vertical-menu group-data-[sidebar-size=lg]:rtl:md:mr-vertical-menu group-data-[sidebar-size=md]:ltr:ml-vertical-menu-md group-data-[sidebar-size=md]:rtl:mr-vertical-menu-md group-data-[sidebar-size=sm]:ltr:ml-vertical-menu-sm group-data-[sidebar-size=sm]:rtl:mr-vertical-menu-sm pt-[calc(theme('spacing.header')_*_1)] pb-[calc(theme('spacing.header')_*_0.8)] px-4 group-data-[navbar=bordered]:pt-[calc(theme('spacing.header')_*_1.3)] group-data-[navbar=hidden]:pt-0 group-data-[layout=horizontal]:mx-auto group-data-[layout=horizontal]:max-w-screen-2xl group-data-[layout=horizontal]:px-0 group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:ltr:md:ml-auto group-data-[layout=horizontal]:group-data-[sidebar-size=lg]:rtl:md:mr-auto group-data-[layout=horizontal]:md:pt-[calc(theme('spacing.header')_*_1.6)] group-data-[layout=horizontal]:px-3 group-data-[layout=horizontal]:group-data-[navbar=hidden]:pt-[calc(theme('spacing.header')_*_0.9)]">
            <div class="grid grid-cols-1 xl:grid-cols-12 gap-x-5">
                <div class="xl:col-span-12">
                    <div class="card">
                        <div class="card-body">
                            <h6 class="mb-1 text-15 grow">Informasi Kontak</h6>
                            <p class="mb-4">Bukti dan konfirmasi pendaftaran akan dikirimkan ke detail informasi kontak yang tertera di sini</p>
                            <form id="applyLeave" action="{{route('registrasirun')}}" method="POST">
                                @csrf
                                <div class="grid grid-cols-1 gap-5 md:grid-cols-2 xl:grid-cols-12">
                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="full_name" class="inline-block mb-2 text-base font-medium">Nama Lengkap *</label>
                                            <input type="text" name="full_name" id="full_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('full_name') is-invalid @enderror" placeholder="Nama Lengkap Pemesan" required="">
                                            <input type="hidden" name="order_id" id="order_id" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" value="{{$kode}}">
                                            @error('full_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="email" class="inline-block mb-2 text-base font-medium">Email</label>
                                            <input type="email" name="email" id="email" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('email') is-invalid @enderror" placeholder="Email"  value="{{ old('email') }}" required="">
                                            @error('email')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="phone" class="inline-block mb-2 text-base font-medium">No. Handphone</label>
                                            <input type="number" name="phone" id="phone" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('telp') is-invalid @enderror" placeholder="Nomor aktif anda" required="">
                                            @error('telp')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="md:col-span-2 xl:col-span-12">
                                        <div>
                                            <label for="alamat" class="inline-block mb-2 text-base font-medium">Alamat Lengkap</label>
                                            <textarea name="alamat" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('alamat') is-invalid @enderror " placeholder="Ketik alamat lengkap anda" rows="3" required=""></textarea>
                                            @error('alamat')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="provinsi" class="inline-block mb-2 text-base font-medium">Provinsi</label>
                                            <select name="provinsi" id="provinsi" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 @error('provinsi') is-invalid @enderror  dark:placeholder:text-zink-200" data-choices="" required>
                                                <option value="">Pilih provinsi </option>
                                                @foreach($prov as $ak)
                                                <option value="{{ $ak->id }}">{{ $ak->nama }}</option>
                                                @endforeach

                                                @error('provinsi')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                                @enderror
                                            </select>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="kabupaten" class="inline-block mb-2 text-base font-medium">Kota/Kabupaten</label>
                                            <select name="kabupaten" id="kabupaten" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" data-choices="" required="">
                                                <option value="">Pilih Kabupaten</option>
                                                @foreach ($kabupatens as $kabupaten)
                                                <option value="{{ $kabupaten->id }}" data-provinsi-id="{{ $kabupaten->provinsi_id }}">
                                                    {{ $kabupaten->nama }}
                                                </option>
                                                @endforeach
                                               
                                            </select>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="negara" class="inline-block mb-2 text-base font-medium">Warga Negara</label>
                                            <!-- <input type="text" name="contry" id="contry" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('contry') is-invalid @enderror" placeholder="contry"> -->
                                            <select name="negara" id="negara" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" data-choices="" required="">
                                                <option value="">Pilih asal negara </option>
                                                @foreach($negara as $key => $ak)
                                                <option value="{{ $ak->id_country }}">{{ $ak->country_name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="xl:col-span-12">
                                    <h6 class="mb-1 text-15 grow">Detail Peserta</h6>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="first_name" class="inline-block mb-2 text-base font-medium">Nama Depan</label>
                                            <input type="text" name="first_name" id="first_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('first_name') is-invalid @enderror" placeholder="Ketik nama depan anda" required="">
                                            @error('first_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-6">
                                        <div>
                                            <label for="last_name" class="inline-block mb-2 text-base font-medium">Nama Belakang</label>
                                            <input type="text" name="last_name" id="last_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('last_name') is-invalid @enderror" placeholder="Ketik nama belakang anda" required="">
                                            @error('last_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>


                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="bib_name" class="inline-block mb-2 text-base font-medium">Nama BIB</label>
                                            <input type="text" name="bib_name" id="bib_name" maxlength = "8" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('bib_name') is-invalid @enderror" placeholder="Maksimal 8 Karakter" required="">
                                            @error('bib_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="dokumen_id" class="inline-block mb-2 text-base font-medium">No. Kartu Identitas/No. Paspor</label>
                                            <input type="text" name="dokumen_id" id="dokumen_id" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('dokumen_id') is-invalid @enderror" placeholder="Nomor kartu identitas/ Paspor" required="">
                                            @error('dokumen_id')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="blood_tipe" class="inline-block mb-2 text-base font-medium">Golongan Darah</label>
                                            <select name="blood_tipe" id="blood_tipe" class="leave_type form-input border-slate-200 focus:outline-none focus:border-custom-500" data-choices="" data-choices-search-false="">
                                                <option value="">Pilih Golongan Darah</option>
                                                <option value="A">A</option>
                                                <option value="B">B</option>
                                                <option value="AB">AB</option>
                                                <option value="O">O</option>
                                     
                                            </select>
                                          
                                        </div>
                                    </div>


                                    <div class="xl:col-span-12">
                                       
                                                <h6 class="mb-4 text-16">Jenis Kelamin</h6>
                                        
                                                <div class="flex flex-wrap gap-2">
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline1" name="jenis_kelamin" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-custom-500 checked:border-custom-500 dark:checked:bg-custom-500 dark:checked:border-custom-500" type="radio" value="pria" checked="">
                                                        <label for="radioInline1" class="align-middle">
                                                            Pria
                                                        </label>
                                                    </div>
                                        
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline2" name="jenis_kelamin" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-green-500 checked:border-green-500 dark:checked:bg-green-500 dark:checked:border-green-500" type="radio" value="Wanita">
                                                        <label for="radioInline2" class="align-middle">
                                                            Wanita
                                                        </label>
                                                    </div>
                                                  
                                                </div>
                                           
                                    </div>



                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="tgl_lahir" class="inline-block mb-2 text-base font-medium">Tanggal Lahir</label>
                                            <input type="date" name="tgl_lahir" id="tgl_lahir" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('tgl_lahir') is-invalid @enderror" required="">
                                            @error('tgl_lahir')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                   

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="category" class="inline-block mb-2 text-base font-medium">Category</label>
                                            <select name="category" id="category" class="leave_type form-input border-slate-200 focus:outline-none focus:border-custom-500" data-choices-search-false="">
                                                @if($kj != 'lDHcl')
                                                <option value="">Pilih Category</option>
                                                <option value="1">Umum</option>
                                                <option value="2">Pelajar</option>
                                               
                                                <option value="4">Elite</option> 
                                                @elseif($kj == 'lDHcl')
                                                <option value="">Pilih Category</option>
                                                <option value="3">Bundling</option> 
                                                @endif
                                            </select>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="package" class="inline-block mb-2 text-base font-medium">Category Run</label>
                                            <select name="package" id="package" class="leave_type form-input border-slate-200 focus:outline-none focus:border-custom-500" data-choices-search-false="">
                                                <option value="">Pilih Category run</option>
                                               
                                            </select>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="price" class="inline-block mb-2 text-base font-medium">Price</label>
                                            <input type="text" name="price" id="price" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('price') is-invalid @enderror" readonly>
                                            @error('price')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div> 
                                    <input type="hidden" name="lokasi_run" id="lokasi_run" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('lokasi_run') is-invalid @enderror" readonly>
                                    <div class="xl:col-span-4" id="lokasi_run_surabaya-dropdown">
                                        <div>
                                            <label for="lokasi_run" class="inline-block mb-2 text-base font-medium">Lokasi Event</label>
                                            <select name="lokasi_run" id="lokasi_run" class="leave_type form-input border-slate-200 focus:outline-none focus:border-custom-500" data-choices="" data-choices-search-false="">
                                               
                                                <option value="">Pilih Lokasi event</option>
                                                <!-- <option value="AL">Bundling (Banyuwangi, Madiun, Kediri, Surabaya)</option>
                                                <option value="BW">Banyuwangi</option>
                                                <option value="MN">Madiun</option>
                                                <option value="KD">Kediri</option> -->
                                                <option value="SB">Surabaya</option>
                                               
                                     
                                            </select>
                                          
                                        </div>
                                    </div>
                                    @if($kj != 'lDHcl' and $kj !='M3ys7')
                                    <div class="xl:col-span-4" id="lokasi_run_non_surabaya-dropdown">
                                        <div>
                                            <label for="lokasi_run" class="inline-block mb-2 text-base font-medium">Lokasi Event</label>
                                            <select name="lokasi_run2" id="lokasi_run2" class="leave_type form-input border-slate-200 focus:outline-none focus:border-custom-500" data-choices="" data-choices-search-false="">
                                                    <option value="">Pilih Lokasi event</option>
                                                    @foreach($lok as $key => $ak)
                                                    <option value="{{ $ak->kode_lokasi }}">{{ $ak->lokasi }}</option>
                                                    @endforeach    
                                            </select>
                                        </div>
                                    </div>
                                    @endif
                                    @if($kj == 'lDHcl' or $kj == 'M3ys7')
                                    <div class="xl:col-span-4">
                                        <div>
                                            <label for="price" class="inline-block mb-2 text-base font-medium">Lokasi Event</label>
                                            <input type="text" name="lokasi_run2" id="lokasi_run2" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" readonly>
                                          
                                        </div>
                                    </div> 
                                    @endif

                                    <div class="xl:col-span-5">
                                        <div class="card">
                                            <div class="card-body">
                                                <h6 class="mb-4 text-16">Size T-Shirt</h6>
                                        
                                                <div class="flex flex-wrap gap-5">
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline1" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-custom-500 checked:border-custom-500 dark:checked:bg-custom-500 dark:checked:border-custom-500" type="radio" value="XS" checked="">
                                                        <label for="radioInline1" class="align-middle">
                                                            XS
                                                        </label>
                                                    </div>
                                        
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline2" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-green-500 checked:border-green-500 dark:checked:bg-green-500 dark:checked:border-green-500" type="radio" value="S">
                                                        <label for="radioInline2" class="align-middle">
                                                            S
                                                        </label>
                                                    </div>
                                        
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline3" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-orange-500 checked:border-orange-500 dark:checked:bg-orange-500 dark:checked:border-orange-500" type="radio" value="M">
                                                        <label for="radioInline3" class="align-middle">
                                                            M
                                                        </label>
                                                    </div>
                                        
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline4" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-purple-500 checked:border-purple-500 dark:checked:bg-purple-500 dark:checked:border-purple-500" type="radio" value="L">
                                                        <label for="radioInline4" class="align-middle">
                                                            L
                                                        </label>
                                                    </div>
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline4" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-red-500 checked:border-red-500 dark:checked:bg-red-500 dark:checked:border-red-500" type="radio" value="XL">
                                                        <label for="radioInline4" class="align-middle">
                                                            XL
                                                        </label>
                                                    </div>
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline4" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-sky-500 checked:border-sky-500 dark:checked:bg-sky-500 dark:checked:border-sky-500" type="radio" value="2XL">
                                                        <label for="radioInline4" class="align-middle">
                                                            2XL
                                                        </label>
                                                    </div>
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline4" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-slate-700 checked:border-slate-700 dark:checked:bg-slate-700 dark:checked:border-slate-700" type="radio" value="3XL">
                                                        <label for="radioInline4" class="align-middle">
                                                            3XL
                                                        </label>
                                                    </div>
                                                    <div class="flex items-center gap-2">
                                                        <input id="radioInline4" name="tshirt_size" class="border rounded-full appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-sky-500 checked:border-sky-500 dark:checked:bg-sky-500 dark:checked:border-sky-500" type="radio" value="4XL">
                                                        <label for="radioInline4" class="align-middle">
                                                            4XL
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="xl:col-span-4">
                                        <p>Ukuran baju yang sudah dipilih tidak dapat ditukar kembali. Desain dan ukuran T-Shirt dapat dilihat <a href="#" data-modal-target="addSizeCart" class="text-red-500">disini</a></p>
                                    </div>   
                                  
                                    
                                    <div class="xl:col-span-12">
                                    <h6 class="mb-1 text-15 grow">Kontak Darurat</h6>
                                    <p>isi informasi kontak darurat yang dapat dihubungi</p>
                                    </div>


                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="emergency_name" class="inline-block mb-2 text-base font-medium">Nama lengkap</label>
                                            <input type="text" name="emergency_name" id="emergency_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('emergency_name') is-invalid @enderror" placeholder="Nama lengkap kontak darurat" required="">
                                            @error('emergency_name')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="telp_emergency" class="inline-block mb-2 text-base font-medium">No. Handphone</label>
                                            <input type="number" name="telp_emergency" id="telp_emergency" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('telp_emergency') is-invalid @enderror" placeholder="Nomor Aktif kontak darurat" required="">
                                            @error('telp_emergency')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="relationEmergency" class="inline-block mb-2 text-base font-medium">Hubungan/Relasi</label>
                                            <input type="text" name="relationEmergency" id="relationEmergency" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('relationEmergency') is-invalid @enderror" placeholder="Keluarga/Teman/Pasangan" required="">
                                            @error('relationEmergency')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <div class="xl:col-span-12">
                                    <div class="flex items-center gap-2">
                                        <input id="checkboxDefault" name="checkboxDefault" class="border rounded-sm appearance-none cursor-pointer size-4 bg-slate-100 border-slate-200 dark:bg-zink-600 dark:border-zink-500 checked:bg-sky-500 checked:border-sky-500 dark:checked:bg-sky-500 dark:checked:border-sky-500 checked:disabled:bg-sky-400 checked:disabled:border-sky-400" type="checkbox" value="">
                                        <label for="checkboxDefault" class="align-middle">
                                        <h6>Saya setuju dengan seluruh <a href="#" data-modal-target="aturanERJF" class="text-sky-600">Aturan dan Ketentuan EJRF 2025</a></h6>
                                        </label>
                                    </div>
                                      
                                        <p>Dengan menulis nama saya di bawah ini, saya menegaskan bahwa saya telah membaca dan menyetujui semua persetujuan dan pernyataan yang saya pilih di atas.</p>
                                    </div>  
                                    
                                    <div class="xl:col-span-12">
                                        <div>
                                            <label for="ttd" class="inline-block mb-2 text-base font-medium">Electronic Signature</label>
                                            <input type="text" name="ttd" id="ttd" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200 @error('ttd') is-invalid @enderror" placeholder="Nama Lengkap">
                                            @error('ttd')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>

                                    <!-- <div class="xl:col-span-6">
                                        <div>
                                            <label for="email" class="inline-block mb-2 text-base font-medium">Email</label>
                                            <input type="email" name="email" id="email" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200">
                                        </div>
                                    </div> -->
                                    
                                    <!-- <div class="xl:col-span-6">
                                        <div>
                                            <label for="bank_name" class="inline-block mb-2 text-base font-medium">Nama Bank</label>
                                           
                                            <select name="bank_name" id="bank_name" class="form-input border-slate-200 dark:border-zink-500 focus:outline-none focus:border-custom-500 disabled:bg-slate-100 dark:disabled:bg-zink-600 disabled:border-slate-300 dark:disabled:border-zink-500 dark:disabled:text-zink-200 disabled:text-slate-500 dark:text-zink-100 dark:bg-zink-700 dark:focus:border-custom-800 placeholder:text-slate-400 dark:placeholder:text-zink-200" data-choices="">
                                                <option value="">Pilih Bank</option>
                                              
                                            </select>
                                        </div>
                                    </div> -->
                                   
                             


                                   
                                </div>
                                <div class="flex justify-end gap-2 mt-4">
                                    <a href="{{URL::to('/')}}" class="text-red-500 bg-white btn hover:text-red-500 hover:bg-red-100 focus:text-red-500 focus:bg-red-100 active:text-red-500 active:bg-red-100 dark:bg-zink-700 dark:hover:bg-red-500/10 dark:focus:bg-red-500/10 dark:active:bg-red-500/10">Batalkan</a>
                                    <button type="submit" id="pay-button" class="text-white btn bg-custom-500 border-custom-500 hover:text-white hover:bg-custom-600 hover:border-custom-600 focus:text-white focus:bg-custom-600 focus:border-custom-600 focus:ring focus:ring-custom-100 active:text-white active:bg-custom-600 active:border-custom-600 active:ring active:ring-custom-100 dark:ring-custom-400/20" disabled>Lanjut Pembayaran</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                
               
            </div>
        </div>    


             <!-- Size Chart-->
             <div id="addSizeCart" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
                <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Size Chart</h5>
                    <button data-modal-close="addSizeCart" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        <!-- <div class="grid grid-cols-1 gap-4 xl:grid-cols-12"> -->
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                              
                                <div class="p-2 text-center">
                                    <img src="assets/size/size_chart.PNG" alt="size" >
                                    
                                </div>
                                
                                
                            </div>
                        </div>

                    
                        
                        <!-- </div> -->
                
                </div>
                </div>
            </div>
            <!--end Size Chart-->

                <!-- Size Chart-->
             <div id="aturanERJF" modal-center="" class="fixed flex flex-col hidden transition-all duration-300 ease-in-out left-2/4 z-drawer -translate-x-2/4 -translate-y-2/4 show ">
                <div class="w-screen md:w-[40rem] bg-white shadow rounded-md dark:bg-zink-600">
                <div class="flex items-center justify-between p-4 border-b dark:border-zink-500">
                    <h5 class="text-16">Aturan dan Ketentuan EJRF 2025</h5>
                    <button data-modal-close="aturanERJF" class="transition-all duration-200 ease-linear text-slate-400 hover:text-red-500"><i data-lucide="x" class="w-5 h-5"></i></button>
                </div>
                <div class="max-h-[calc(theme('height.screen')_-_180px)] p-4 overflow-y-auto">
                
                        
                        <div class="!shadow-lg text-15 card">
                            <div class="card-body">
                              
                                <div class="p-2 text-center">
                                    <p>isi aturan</p>
                                    
                                </div>
                                
                                
                            </div>
                        </div>

                    
                        
                        <!-- </div> -->
                
                </div>
                </div>
            </div>
            <!--end Size Chart-->

@section('script')
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
        $(document).ready(function() {
            // Set tombol button disabled berdasarkan status checkbox
            $('#checkboxDefault').change(function() {
                if ($(this).is(':checked')) {
                    $('#pay-button').prop('disabled', false); // Menonaktifkan tombol jika checkbox dicentang
                } else {
                    $('#pay-button').prop('disabled', true); // Mengaktifkan tombol jika checkbox tidak dicentang
                }
            });
        });
</script>


<script>
    $(document).ready(function () {
        // Ketika dropdown provinsi dipilih
        $('#provinsi').on('change', function () {
            var provinsi_id = $(this).val();

            // Menampilkan hanya kabupaten yang sesuai dengan provinsi_id
            $('#kabupaten option').each(function () {
                var optionProvinsiId = $(this).data('provinsi-id');
                if (provinsi_id === "" || optionProvinsiId == provinsi_id) {
                    $(this).show();
                } else {
                    $(this).hide();
                }
            });

            // Reset kabupaten jika provinsi tidak dipilih
            if (provinsi_id === "") {
                $('#kabupaten').val('');
            }
        });
    });
</script>

<script>
    $('#package').on('change', function(){
    // ambil data dari elemen option yang dipilih
    const price = $('#package option:selected').data('price');

    // tampilkan data ke element
    $('[name=price]').val(price);

    });
</script>  


<script>
    $('#package').on('change', function(){
    // ambil data dari elemen option yang dipilih
    const ket = $('#package option:selected').data('keterangan');

    // tampilkan data ke element
    $('[name=lokasi_run2]').val(ket);

    });

</script>  

<script>
        $(document).ready(function () {
            $('#category').change(function () {
                var category = $(this).val();

                // Cek jika ada kategori yang dipilih
                if (category) {
                    $.ajax({
                        url: '/get-items/{{$kj}}',
                        type: 'GET',
                        data: {type: category},
                        success: function (data) {
                            $('#package').empty(); // Kosongkan dropdown item sebelumnya
                            $('#package').append('<option value="">Pilih Category run</option>');
                            $.each(data, function (key, value) {
                                $('#package').append('<option data-Price="' + value.harga_tiket + '" data-keterangan="' + value.keterangan_tiket + '" value="' + value.id_kat_event + '">' + value.nama_kat_event +' ('+ value.keterangan_tiket +')'+'</option>');
                            });
                        }
                    });
                } else {
                    $('#items').empty();
                    $('#items').append('<option value="">Pilih kategori terlebih dahulu</option>');
                }
            });
        });
</script>

<script>
    // Ketika jenis (buah/sayuran) dipilih
    document.addEventListener("DOMContentLoaded", function() {
        // var jenis = $(this).val(); // Ambil nilai pilihan (buah atau sayuran)
        const jenis = document.getElementById('package');
        var_dump(jenis);
        // Cek apakah yang dipilih adalah buah atau sayuran
        if (jenis == 'ELyx4') {
            $('#lokasi_run_surabaya-dropdown').show();  // Tampilkan dropdown buah
            $('#lokasi_run_non_surabaya-dropdown').hide();  // Sembunyikan dropdown sayuran
        } else if (jenis == 'q72VN') {
            $('#lokasi_run_non_surabaya-dropdown').show();  // Tampilkan dropdown sayuran
            $('#lokasi_run_surabaya-dropdown').hide();  // Sembunyikan dropdown buah
        }
    });

    // Saat halaman pertama kali dimuat, sembunyikan dropdown sayuran
    $(document).ready(function() {
        $('#lokasi_run_surabaya-dropdown').hide();  // Sembunyikan dropdown sayuran
    });
</script>



@endsection
@endsection