@extends('layoutsutama.master3')
@section('content')
        <!-- dari sini -->

       
        <section class="relative pb-36 pt-44">
            <div class="container 2xl:max-w-[87.5rem] px-4 mx-auto">
                <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                    @foreach ($events as $event)
                        <a href="{{ url('run/'.$event->event_id) }}" class="block">
                            <div class="shadow-lg rounded-lg overflow-hidden bg-white w-[300px] h-[400px] flex flex-col">
                                <div class="relative basis-1/2" >
                                    <img src="{{ asset('assets/upload/banner/' . $event->banner) }}" alt="Event Image" class="w-full h-full object-cover">
                                </div>
                                <div class="basis-1/2 p-4 flex flex-col justify-between">
                                    <div>
                                        <h3 class="text-lg font-semibold text-slate-800 leading-snug">
                                            {{ $event->event_name }}
                                        </h3>
                                        <p class="text-[13px] text-slate-500">
                                            {{ $event->address_event }}
                                        </p>
                                        <hr>
                                        <p class="text-[13px] text-slate-700 mt-1">
                                            {{ \Carbon\Carbon::parse($event->date_event)->format('j F Y') }}
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </a>
                    @endforeach
                </div>

            </div>
        </section>

         <!-- sampai sini -->

      
@endsection