<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Peserta extends Model
{
    use HasFactory;
    public $incrementing = false;
    protected $primaryKey = 'order_id';
    protected $table = 'peserta';
    protected $fillable = [
        'order_id',
        'urutan',
        'bib_number',
        'full_name',
        'first_name',
        'last_name',
        'email',
        'phone',
        'bib_name',
        'jenis_no_identitas',
        'dokumen_id',
        'blood_tipe',
        'jenis_kelamin',
        'tgl_lahir',
        'category',
        'tshirt_size',
        'community',
        'emergency_name',
        'telp_emergency',
        'relationEmergency',
        'package',
        'lokasi_run',
        'alamat',
        'provinsi',
        'kabupaten',
        'negara',
        'voucher',
        'price',
        'pembayaran',
        'ttd',
        'lisensi',
        'konfirmasi_email',
        'konfirmasi_kehadiran',
        'loket'

    ];
     /**
     * Set status to Pending
     *
     * @return void
     */
    public function setPending()
    {
        $this->attributes['pembayaran'] = 'pending';
        self::save();
    }

    /**
     * Set status to Success
     *
     * @return void
     */
    public function setSuccess()
    {
        $this->attributes['pembayaran'] = 'success';
        self::save();
    }

    /**
     * Set status to Failed
     *
     * @return void
     */
    public function setFailed()
    {
        $this->attributes['pembayaran'] = 'failed';
        self::save();
    }

    /**
     * Set status to Expired
     *
     * @return void
     */
    public function setExpired()
    {
        $this->attributes['pembayaran'] = 'expired';
        self::save();
    }
}
