<?php

namespace App\Imports;

use Carbon\Carbon;
use App\Models\Peserta;
use Illuminate\Support\Str;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;


class PesertaImport implements ToModel, WithHeadingRow
{
   
    public function model(array $row)
    {
        $kode = 'EJ'.Str::random(15).date('ym').'BW'.date('d');
        $tglLahir = $row['tgl_lahir'] ?? null;

        if (!empty($tglLahir)) {
            // Jika formatnya angka (Excel timestamp)
            if (is_numeric($tglLahir)) {
                $tglLahir = Carbon::createFromTimestamp(($tglLahir - 25569) * 86400)->format('Y-m-d');
            } 
            // Jika formatnya "24/08/1999" atau "24-08-1999"
            elseif (preg_match('/\d{2}\/\d{2}\/\d{4}/', $tglLahir)) {
                try {
                    $tglLahir = Carbon::createFromFormat('d/m/Y', $tglLahir)->format('Y-m-d');
                } catch (\Exception $e) {
                    $tglLahir = null;
                }
            } elseif (preg_match('/\d{2}-\d{2}-\d{4}/', $tglLahir)) {
                try {
                    $tglLahir = Carbon::createFromFormat('d-m-Y', $tglLahir)->format('Y-m-d');
                } catch (\Exception $e) {
                    $tglLahir = null;
                }
            } else {
                $tglLahir = null; // Jika format tidak dikenali
            }
        }

        // Jika tetap null dan database tidak mengizinkan NULL, berikan nilai default yang lebih aman
        if ($tglLahir === null) {
            $tglLahir = '1970-01-01'; // Bisa disesuaikan
        }


        return new Peserta ([
            'order_id' =>$kode,
            'full_name' =>$row['full_name'],
            'first_name' =>$row['first_name'],
            'last_name'=>$row['last_name'],
            'email' =>$row['email'],
            'phone' =>$row['phone'],
            'bib_name' =>$row['bib_name'],
            'dokumen_id' =>$row['dokumen_id'],
            'blood_tipe' =>$row['blood_tipe'],
            'jenis_kelamin' =>$row['jenis_kelamin'],
            'tgl_lahir' => $tglLahir,
            'category' =>$row['category'],
            'tshirt_size' =>$row['tshirt_size'],
            'community' =>$row['community'],
            'emergency_name' =>$row['emergency_name'],
            'telp_emergency' =>$row['telp_emergency'],
            'relationEmergency' =>'-',
            'package' =>$row['package'],
            'lokasi_run' =>$row['lokasi_run'],
            'alamat' =>$row['alamat'],
            'provinsi' =>$row['provinsi'],
            'kabupaten' =>$row['kabupaten'],
            'negara' =>$row['negara'],
            'voucher' =>$row['voucher'],
            'price' =>$row['price'],
            'pembayaran' =>$row['pembayaran'],
            'ttd' =>$row['ttd'],
        ]);
    }

   

}
