<?php

namespace App\Http\Controllers;

use DB;
use Hash;
use Session;
use App\Models\ic;
use Carbon\Carbon;
use App\Models\User;
use App\Models\blood;
use App\Models\gender;
use App\Models\ActivityLog;
use App\Models\participant;
use App\Models\size_jersey;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\company_event;
use App\Models\Kategori_event;
use App\Models\ticket_company;
use App\Models\category_ticket;
use App\Models\running_company;
use Brian2694\Toastr\Facades\Toastr;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;


class SettingAdminController extends Controller
{
    // Company/EO list
    public function companyList()
    {
        $list = running_company::where('active_company',1)->get();
        

       return view('admin.listCompany',compact('list'));
    }

     public function companyListById()
    {
        $list = running_company::where('active_company',1)->where('')->get();
        

       return view('admin.listCompany',compact('list'));
    }

    


    public function saveRecordcompany(Request $request)
    {
        $request->validate([

            'company_name' => 'required|string',
            'address'=>'required|string',
            'Telp' => 'required',
            'email' => 'required|string|email|max:255|unique:users',
            'name' => 'required|string',
            'password' => 'required|string|min:8|confirmed',
                   
        ]);
        
        try {
            
                $id_tik = Str::random(5);
                $tiket = new running_company();
                $tiket->fill([
                    'company_id'         => $id_tik,
                    'company_name'       => Str::upper($request->company_name),
                    'address'            => $request->address,   
                    'Telp'               => $request->Telp,
                    'email'              => $request->email, 
                    'active_company'     => 1,
                ]);
                $tiket->save();

                // add username
                $register = new User();
                $register->name         = $request->name;
                $register->email        = $request->email;
                $register->join_date    = Carbon::now()->toDayDateTimeString();
                $register->role_name    = 'User';
                $register->department   = $id_tik;
                $register->status       = 'Active';
                $register->password     = Hash::make($request->password);
                $register->save();

                ActivityLog::createLog(
                    'Create',
                    'User AND Running_company',
                    $tiket->company_id,
                    'Menambahkan User AND Running_company : ' . $tiket->company_name .'-'. $register->name
                );

            Toastr::success('Company Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Company Gagal dibuat', 'Error');
            return redirect()->back();
        }
    }

    
    public function companyUpdateRecord(Request $request)
    {
       
        try {

            $comp = running_company::findOrFail($request->id);

            $comp->update([
                $comp->company_name           = Str::upper($request->company_name),
                $comp->address                = $request->address,
                $comp->Telp                   = $request->Telp,
                $comp->email                  = $request->email,

            ]);

                ActivityLog::createLog(
                    'Update',
                    'Running_company',
                    $comp->company_id,
                    'Edit Running_company : ' . $comp->company_name
                );

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function companyDeleteRecord(Request $request) 
    {
        try {
            // Find the tiket record or fail if not found
            $syarat = running_company::findOrFail($request->id_delete);
            $syarat->active_company = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Delete',
                    'Running_company',
                    $syarat->company_id,
                    'Hapus Running_company : ' . $syarat->company_name
                );

            
            Toastr::success('Company Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Company Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // Event List
    public function eventListById($comp,$id)
    {
        $list = company_event::join('running_company','company_event.company_id','=','running_company.company_id')
                ->where('company_event.event_id',$id)
                ->get();
           
              
        $name_comp = running_company::where('company_id',$comp)->value('company_name');        

        $cop = $comp;
       return view('admin.listEventById',compact('list','cop','name_comp'));
    }

      public function eventList()
    {
        $list = company_event::join('running_company','company_event.company_id','=','running_company.company_id')
                ->get();

        $comp = running_company::all();
       return view('admin.listEvent',compact('list','comp'));
    }

    public function saveRecordevent(Request $request)
    {
        $request->validate([
                    'company_id'    => 'required|string|max:5',
                    'event_name'    => 'required|string|max:100',
                    'address_event' => 'required|string|max:255',
                    'date_event'    => 'required|date',
                    'banner'        => 'nullable|image|mimes:jpeg,jpg,png,webp|max:2048',
        ]);

        try {
            $bannerFileName = null;

            if ($request->hasFile('banner')) {
                $request->validate([
                    
                    'banner' => 'image|mimes:jpeg,jpg,png,webp|max:2048',
                ]);

                $file = $request->file('banner');
                $bannerFileName = Str::slug($request->event_name,'_') . '.' . $file->getClientOriginalExtension();
                $destinationPath = public_path('assets/upload/banner');
                $savePath = $destinationPath . '/' . $bannerFileName;

                // Buat folder jika belum ada
                if (!file_exists($destinationPath)) {
                    mkdir($destinationPath, 0755, true);
                }

                // Resize dan simpan menggunakan Intervention Image v3
                $manager = new ImageManager(new Driver());
                $image = $manager->read(fopen($file->getRealPath(), 'r'));
                $image->cover(828, 455)->save($savePath);
            }
            $id_tik = Str::random(8);
            $cev = new company_event();
            $cev->fill([
                'event_id'             => $id_tik,
                'company_id'           => $request->company_id,
                'event_name'           => Str::upper($request->event_name),
                'medsos'               => $request->medsos,
                'no_telp'              => $request->no_telp,
                'address_event'        => $request->address_event,
                'date_event'           => $request->date_event,
                'banner'               => $bannerFileName,
                'target_peserta'       => $request->target_peserta,
                'start_event'          => $request->start_event,
                'end_event'            => $request->end_event,
                'active_company_event' => 1,
            ]);
            $cev->save();

                ActivityLog::createLog(
                    'Create',
                    'company_event',
                    $cev->event_id,
                    'Menambahkan company event : ' . $cev->event_name
                );
            
            Toastr::success('Event Company Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Event Company gagal dibuat', 'Error');
            return redirect()->back();
        }
    }

    
    public function eventUpdateRecord(Request $request)
    {

         $request->validate([
            'id'             => 'required',
            'event_name'     => 'required|string|max:255',
            'address_event'  => 'nullable|string|max:500',
            'date_event'     => 'required|date',
            
        ]);

   

        try {

            $comp = company_event::where('event_id',$request->id)->firstOrFail();

            // Cek jika ada file baru diupload
            if ($request->hasFile('event_image')) {
                 $request->validate([
                    'event_image' => 'image|mimes:jpeg,jpg,png,webp|max:2048',
                ]);
                // Hapus banner lama jika ada
                if ($comp->banner && file_exists(public_path('assets/upload/banner/' . $comp->banner))) {
                    unlink(public_path('assets/upload/banner/' . $comp->banner));
                }

                $file = $request->file('event_image');
                $filename = Str::slug($request->event_name,'_') . '.' . $file->getClientOriginalName();
                $savePath = public_path('assets/upload/banner/' . $filename);
                // Resize gambar jadi 828x455
                // Inisialisasi ImageManager dengan driver GD
                $manager = new ImageManager(new Driver());

                  // Gunakan stream untuk decoding
                $image = $manager->read(fopen($file->getRealPath(), 'r'));

                // Resize & simpan
                $image->cover(828, 455)->save($savePath);
                $comp->banner = $filename;
            }

                $comp->company_id           = $request->company_id;
                $comp->event_name           = Str::upper($request->event_name);
                $comp->medsos               = $request->medsos;
                $comp->no_telp              = $request->no_telp;
                $comp->address_event        = $request->address_event;
                $comp->date_event           = $request->date_event;
                $comp->start_event          = $request->start_event;
                $comp->end_event            = $request->end_event;
                $comp->save();

                ActivityLog::createLog(
                    'Update',
                    'company_event',
                    $comp->event_id,
                    'Edit company event : ' . $comp->event_name
                );

           

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function eventDeleteRecord(Request $request) 
    {
        try {
            
      
            $syarat = company_event::where('event_id',$request->id_delete)->firstOrFail();
            $syarat->active_company_event = 0; 
            $syarat->update();

            ActivityLog::createLog(
                    'Delete',
                    'company_event',
                    $syarat->event_id,
                    'Hapus company event : ' . $syarat->event_name
                );

            
            Toastr::success('Event Company Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Event Company Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // Kategori Event
    public function kategoriEventList()
    {
        $list = Kategori_event::where('active_kategoriEvent',1)->get();
        return view('admin.kategoriEventList',compact('list'));
    }

    public function saveRecordkategoriEvent(Request $request)
    {
        $request->validate([

            'kategoriEvent_name' => 'required|string',       
        ]);
        
        try {
                $tiket = new Kategori_event();
                $tiket->fill([
                 
                    'kategoriEvent_name'       => Str::upper($request->kategoriEvent_name),
                    'active_kategoriEvent'     => 1,   
                 
                ]);
                $tiket->save();

                ActivityLog::createLog(
                    'Create',
                    'Kategori_event',
                    $tiket->id,
                    'Menambahkan kategori event: ' . $tiket->kategoriEvent_name
                );

            Toastr::success('Category Event Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Category Event dibuat', 'Error');
            return redirect()->back();
        }
    }

    
    public function kategoriEventUpdateRecord(Request $request)
    {
        try {

            $comp = Kategori_event::findOrFail($request->id);

            $comp->update([
                $comp->kategoriEvent_name           = Str::upper($request->kategoriEvent_name),
                

            ]);

            ActivityLog::createLog(
                    'Update',
                    'Kategori_event',
                    $comp->id,
                    'Edit kategori event: ' . $comp->kategoriEvent_name
                );

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function kategoriEventDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = Kategori_event::findOrFail($request->id_delete);
            $syarat->active_kategoriEvent = 0; 
            $syarat->update();

            ActivityLog::createLog(
                'Delete',
                'Kategori_event',
                $syarat->id,
                'Hapus kategori event: ' . $syarat->kategoriEvent_name
            );


            
            Toastr::success('category Event Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('ategory Event Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // Gender List
    public function gendertList()
    {
        $list = gender::where('active_gender',1)->get();
        return view('admin.gendertList',compact('list'));
    }

       public function saveRecordgender(Request $request)
    {
        $request->validate([

            'gender_name' => 'required|string',       
        ]);
        
        try {
                $tiket = new gender();
                $tiket->fill([
                 
                    'gender_name'       => Str::upper($request->gender_name),
                    'active_gender'     => 1,   
                 
                ]);
                $tiket->save();

                ActivityLog::createLog(
                    'Create',
                    'Gender',
                    $tiket->id,
                    'Menambahkan gender : ' . $tiket->gender_name
                );

            Toastr::success('Gender Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Gender dibuat', 'Error');
            return redirect()->back();
        }
    }

    
    public function genderUpdateRecord(Request $request)
    {
        try {

            $comp = gender::findOrFail($request->id);

            $comp->update([
                $comp->gender_name           = Str::upper($request->gender_name),
            ]);

            ActivityLog::createLog(
                'Update',
                'Gender',
                $comp->id,
                'Edit gender : ' . $comp->gender_name
            );

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function genderDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = gender::findOrFail($request->id_delete);
            $syarat->active_gender = 0; 
            $syarat->update();

            ActivityLog::createLog(
                'Delete',
                'Gender',
                $syarat->id,
                'Hapus gender : ' . $syarat->gender_name
            );

            
            Toastr::success('category Event Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Category Event Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // participant
    public function participantlist()
    {
        $list = participant::where('participant_active',1)->get();
        return view('admin.participantlist',compact('list'));
    }

    public function saveRecordparticipant(Request $request)
    {
        $request->validate([

            'participant_name' => 'required|string',       
        ]);
        
        try {
                $parti = new participant();
                $parti->fill([
                 
                    'participant_name'       => Str::title($request->participant_name),
                    'participant_active'     => 1,   
                 
                ]);
                $parti->save();

                ActivityLog::createLog(
                    'Create',
                    'participant',
                    $parti->id,
                    'Menambahkan participant : ' . $parti->participant_name
                );


            Toastr::success('Participant Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Participant dibuat', 'Error');
            return redirect()->back();
        }
        
    }

     public function participantUpdateRecord(Request $request)
    {
        try {

            $parti = participant::findOrFail($request->id);

            $parti->update([
                $parti->participant_name           = Str::title($request->participant_name),
            ]);

                ActivityLog::createLog(
                    'Update',
                    'participant',
                    $parti->id,
                    'Edit participant : ' . $parti->participant_name
                );

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function gparticipantDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = participant::findOrFail($request->id_delete);
            $syarat->participant_active = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Delete',
                    'participant',
                    $syarat->id,
                    'Hapus participant : ' . $syarat->participant_name
                );

            
            Toastr::success('Perticipant Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Perticipant Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // Category Tiket
    public function categoryTicketList()
    {
        $list = category_ticket::where('category_ticket_active',1)->get();
        return view('admin.categoryTicketList',compact('list'));
    }

    public function saveRecordcategoryTicket(Request $request)
    {
        $request->validate([

            'category_ticket_name' => 'required|string',       
        ]);
        
        try {
                $parti = new category_ticket();
                $parti->fill([
                 
                    'category_ticket_name'       => Str::upper($request->category_ticket_name),
                    'category_ticket_active'     => 1,   
                 
                ]);
                $parti->save();

                ActivityLog::createLog(
                    'Create',
                    'category_ticket',
                    $parti->id,
                    'Menambahkan Category tiket : ' . $parti->category_ticket_name
                );

            Toastr::success('Category ticket Berhasil dibuat', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Category ticket dibuat', 'Error');
            return redirect()->back();
        }
        
    }

     public function categoryTicketUpdateRecord(Request $request)
    {
        try {

            $parti = category_ticket::findOrFail($request->id);

            $parti->update([
                $parti->category_ticket_name           = Str::upper($request->category_ticket_name),
            ]);

                ActivityLog::createLog(
                    'Update',
                    'category_ticket',
                    $parti->id,
                    'Edit Category tiket : ' . $parti->category_ticket_name
                );

            Toastr::success('updated sukses','Success');
            return redirect()->back();
        } catch(\Exception $e) {
            \Log::info($e);
            Toastr::error('gagal, update record','Error');
            return redirect()->back();
        }

    }

    public function categoryTicketDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = category_ticket::findOrFail($request->id_delete);
            $syarat->category_ticket_active = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Delete',
                    'category_ticket',
                    $syarat->id,
                    'Hapus Category tiket : ' . $syarat->category_ticket_name
                );

            
            Toastr::success('Perticipant Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Perticipant Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // Ticket company
    public function ticketList($id)
    {
        $list = ticket_company::join('company_event','ticket_company.event_id','=','company_event.event_id')
                ->join('category_ticket','ticket_company.category_ticket_id','=','category_ticket.id')
                ->where('active_ticket_company',1)
                ->where('company_event.event_id',$id)
                ->orderBy('ticket_company.event_id','asc')
                ->get();
                // dd($list);
        // Decode dan ambil participant manual
        foreach ($list as $item) {
            $participant_ids = json_decode($item->category_participant_id, true); // true = array
            if (is_array($participant_ids) && count($participant_ids) > 0) {
                $participants = participant::whereIn('id', $participant_ids)->get();
            } else {
                $participants = collect(); // kosong jika null atau bukan array
            }

            $item->participant_list = $participants;
        }        
        $comp = company_event::where('active_company_event',1)->get();
        $kat =  category_ticket::where('category_ticket_active',1)->get();
        $katEv = kategori_event::where('active_kategoriEvent',1)->get();
        $party = participant::all();

        $name = company_event::where('event_id',$id)->value('event_name');
        $ev_id = $id;
        // dd($ev_id);
        return view('admin.ticketCompanylist',compact('list','comp','kat','katEv','party','name','ev_id'));
    }

    public function saveRecordticket(Request $request)
    {

        $request->validate([
                'event_id'           => 'required|string|max:10',
                // 'ticket_name'        => 'required',
                'category_ticket_id' => 'required|integer',
                'start_date'         => 'required|date',
                'end_date'           => 'required|date|after_or_equal:start_date',
                'kuota_ticket'       => 'nullable|integer|min:0'
            ]);

        $cc = kategori_event::where('id',$request->category_event_id)->get();
        $cc_name = $cc[0]->kategoriEvent_name;

        $ct = category_ticket::where('id',$request->category_ticket_id)->get();
        $ct_name = $ct[0]->category_ticket_name;  
        
        $cek = ticket_company::where('event_id',$request->event_id)
                                ->where('category_event_id',$request->category_event_id)
                                ->where('category_ticket_id',$request->category_ticket_id)
                                ->get();
        if ($cek->isEmpty()) {
            try {
                    $code = Str::random(5);
                ticket_company::create([
                    'ticket_id'               =>  $code,// generate ID 5 karakter
                    'event_id'                => $request->event_id,
                    'ticket_name'             => Str::upper($cc_name),
                    'category_event_id'       => $request->category_event_id,
                    'category_ticket_id'      => $request->category_ticket_id,
                    'enable_kuota_ticket'     => $request->has('enable_kuota_ticket') ? 1 : 0,
                    'kuota_ticket'            => $request->has('enable_kuota_ticket') ? $request->kuota_ticket : 0,
                    'enable_kuota_participant'=> $request->enable_kuota_participant ?? 0,
                    'category_participant_id' => NUll,
                    'jersey'                  => $request->jersey,
                    'price'                   => $request->price,
                    'start_date'              => $request->start_date,
                    'end_date'                => $request->end_date,
                    // 'category_participant_id' => json_encode($request->category_participant_id),
                    'active_ticket_company'=> 1,
                ]);

                ActivityLog::createLog(
                    'Create',
                    'ticket_company',
                    $code,
                    'Menambahkan Ticket company : ' . Str::upper($cc_name)
                );

                Toastr::success('Ticket successfully saved.', 'Success');
                return redirect()->back();
            } catch (\Exception $e) {
                \Log::error($e); // Log the error
                Toastr::error('Failed to save ticket event', 'Error');
                return redirect()->back();
            }
        } else {
            Toastr::warning('Ticket with the same category already exists.', 'Warning');
            return redirect()->back();
        }    
    }


        public function ticketUpdateRecord(Request $request)
        {
            // Validasi data
            $validated = $request->validate([
                'ticket_id'                 => 'required',
                'event_id'                  => 'required|exists:company_event,event_id',
                'category_event_id'         => 'required|exists:kategori_event,id',
                'category_ticket_id'        => 'required|exists:category_ticket,id',
                'jersey'                    => 'required',
                'price'                     => 'required|numeric|min:0',
                // 'category_participant_id'   => 'required|array',
                // 'category_participant_id.*' => 'exists:participant,id',
                // 'enable_kuota_participant'  => 'boolean',
                'start_date'                => 'required|date',
                'end_date'                  => 'required|date|after_or_equal:start_date',
                'kuota_ticket'              => 'nullable|integer|min:0',
                'enable_kuota_ticket'       => 'nullable|in:on'
            ]);

            // Ambil data tiket yang akan diupdate
            $ticket = ticket_company::findOrFail($validated['ticket_id']);

            try {
                // Update field
                $ticket->event_id = $validated['event_id'];
                $ticket->category_event_id = $validated['category_event_id'];
                $ticket->category_ticket_id = $validated['category_ticket_id'];
                // $ticket->category_participant_id =$validated['category_participant_id'];
                $ticket->jersey = $validated['jersey'];
                $ticket->price = $validated['price'];
                $ticket->enable_kuota_participant = $request->has('enable_kuota_participant') ? 1 : 0;
              
                $ticket->start_date = $validated['start_date'];
                $ticket->end_date = $validated['end_date'];

                // Tangani checkbox enable_kuota
                $ticket->enable_kuota_ticket = $request->has('enable_kuota_ticket') ? 1 : 0;
                $ticket->kuota_ticket = $ticket->enable_kuota_ticket ? $validated['kuota_ticket'] : 0;

                // Simpan perubahan
                $ticket->save();

                ActivityLog::createLog(
                    'Update',
                    'ticket_company',
                    $validated['ticket_id'],
                    'Edit Ticket company : ' . $validated['category_event_id']
                );

                Toastr::success('Ticket Event successfully updated.', 'Success');
                return redirect()->back();
             } catch (\Exception $e) {
                \Log::error($e); // Log the error
                Toastr::error('Ticket Event updated failed!', 'Error');
                return redirect()->back();
            }
        }
    
        //size jersey
    public function sizeJerseyList($id)
    {
        $list = size_jersey::join('company_event','size_jersey.company_event_id','=','company_event.event_id')
                ->where('active_size_jersey',1)
                ->where('event_id',$id)
                ->select('size_jersey.*', 'company_event.*', 'size_jersey.id as size_jersey_id')
                ->get();
        $comp = ticket_company::where('jersey',1)->get();
        $name = company_event::where('event_id',$id)->value('event_name');
        return view('admin.sizeJerseyList',compact('list','comp','name'));
    }

    public function saveRecordsizeJersey(Request $request)
    {

        $request->validate([
                'company_event_id'         => 'required',
                'size_jersey'              => 'required',
                'size'                     => 'required',
            ]);

        try {
            size_jersey::create([
                
                'company_event_id'     => $request->company_event_id,
                'size_jersey'          => Str::upper($request->size_jersey),
                'size'                 => Str::upper($request->size),
                'active_size_jersey'   => 1,
            ]);

                ActivityLog::createLog(
                    'Create',
                    'size_jersey',
                    $request->company_event_id,
                    'Menambahkan Size Jersey : ' . Str::upper($request->size_jersey)
                );

            Toastr::success('Size jersey successfully saved.', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Failed to save Size jersey', 'Error');
            return redirect()->back();
        }
    }

    public function sizeJerseyUpdateRecord(Request $request)
        {
            // Validasi data
            $validated = $request->validate([
                'id'              => 'required',
                'size_jersey'         => 'required',
                'size'         => 'required',
               
            ]);

            // Ambil data tiket yang akan diupdate
            $ic = size_jersey::findOrFail($validated['id']);

            try {
                // Update field
                $ic->size_jersey    = Str::upper($validated['size_jersey']);
                $ic->size           = Str::upper($validated['size']);
                // Simpan perubahan
                $ic->save();

                ActivityLog::createLog(
                    'Update',
                    'size_jersey',
                    $validated['id'],
                    'Edit Size Jersey : ' . Str::upper($validated['size_jersey'])
                );

                Toastr::success('size jersey successfully updated.', 'Success');
                return redirect()->back();
             } catch (\Exception $e) {
                \Log::error($e); // Log the error
                Toastr::error('size jersey updated failed!', 'Error');
                return redirect()->back();
            }
        }

    public function sizeJerseyDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = size_jersey::findOrFail($request->id_delete);
            $syarat->active_size_jersey = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Update',
                    'size_jersey',
                    $syarat->id,
                    'Edit Size Jersey : ' . $syarat->size_jersey
                );
            
            Toastr::success('Size jersey Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Size jersey Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    // ic ist

    public function icList()
    {
        $list = ic::where('active_ic',1)->get();
        return view('admin.icList',compact('list'));
    }

    public function saveRecordic(Request $request)
    {

        $request->validate([
                
                'name_ic'         => 'required',
                
            ]);

      

        try {
            ic::create([
                
                'name_ic'     => Str::upper($request->name_ic),
                'active_ic'   => 1,
            ]);

                ActivityLog::createLog(
                    'Create',
                    'IC',
                    Str::upper($request->name_ic),
                    'Menambahkan IC : ' . Str::upper($request->name_ic)
                );

            Toastr::success('IC successfully saved.', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Failed to save IC', 'Error');
            return redirect()->back();
        }
    }

     public function icUpdateRecord(Request $request)
        {
            // Validasi data
            $validated = $request->validate([
                'id'              => 'required',
                'name_ic'         => 'required',
             
               
            ]);
            

            // Ambil data tiket yang akan diupdate
            $ic = ic::findOrFail($validated['id']);

            try {
                // Update field
                $ic->name_ic = Str::upper($validated['name_ic']);

                // Simpan perubahan
                $ic->save();

                ActivityLog::createLog(
                    'Update',
                    'IC',
                    Str::upper($validated['name_ic']),
                    'Edit IC : ' . Str::upper($validated['name_ic'])
                );

                Toastr::success('IC successfully updated.', 'Success');
                return redirect()->back();
             } catch (\Exception $e) {
                \Log::error($e); // Log the error
                Toastr::error('IC updated failed!', 'Error');
                return redirect()->back();
            }
        }


 public function icDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = ic::findOrFail($request->id_delete);
            $syarat->active_ic = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Delete',
                    'IC',
                    $syarat->id,
                    'Delete IC : ' . $syarat->name_ic
                );

            
            Toastr::success('IC Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('IC Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }

    public function bloodList()
    {
        $list = blood::where('active_blood',1)->get();
        return view('admin.bloodList',compact('list'));
    }

     public function saveRecordblood(Request $request)
    {

        $request->validate([
                
                'name_blood'         => 'required',
                
            ]);

      

        try {
            blood::create([
                
                'name_blood'     => Str::upper($request->name_blood),
                'active_blood'   => 1,
            ]);

                ActivityLog::createLog(
                    'Create',
                    'Blood',
                    Str::upper($request->name_blood),
                    'Menambahkan Blood : ' . Str::upper($request->name_blood)
                );


            Toastr::success('Blood successfully saved.', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Failed to save Blood', 'Error');
            return redirect()->back();
        }
    }

     public function bloodUpdateRecord(Request $request)
        {
            // Validasi data
            $validated = $request->validate([
                'id'              => 'required',
                'name_blood'      => 'required',
             
               
            ]);

            // Ambil data tiket yang akan diupdate
            $ic = blood::findOrFail($validated['id']);

            try {
                // Update field
                $ic->name_blood = Str::upper($validated['name_blood']);

                // Simpan perubahan
                $ic->save();

                ActivityLog::createLog(
                    'Update',
                    'Blood',
                    Str::upper($validated['name_blood']),
                    'Edit Blood : ' . Str::upper($validated['name_blood'])
                );

                Toastr::success('IC successfully updated.', 'Success');
                return redirect()->back();
             } catch (\Exception $e) {
                \Log::error($e); // Log the error
                Toastr::error('IC updated failed!', 'Error');
                return redirect()->back();
            }
        }

    public function bloodDeleteRecord(Request $request) 
    {
        try {
            
            $syarat = blood::findOrFail($request->id_delete);
            $syarat->active_blood = 0; 
            $syarat->update();

                ActivityLog::createLog(
                    'Update',
                    'Blood',
                    $Syarat->id,
                    'Edit Blood : ' . $syarat->name_blood
                );

            
            Toastr::success('Blood Berhasil Dihapus', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Blood Gagal Dihapus', 'Error');
            return redirect()->back();
        }
    }
        

    public function ticketKriteriaList()
    {
        $list = ic::where('active_ic',1)->get();
        return view('admin.ticketCriteriaList',compact('list'));
    }

    public function logList()
    {
        $list = ActivityLog::all();
        return view('admin.log',compact('list'));
    }

    public function userList()
    {
        $list = User::all();
        $Cev = company_event::all();
        return view('admin.user',compact('list','Cev'));
    }

 

    public function saveRecorduser(Request $request)
    {

        $request->validate([
                'name'         => 'required',  
            ]);
        try {
            $dep = $request->role_name == 'Loket' ? '-': $request->department;
            User::create([
                
                'name'          => Str::upper($request->name),
                'email'         => $request->email,
                'phone_number'  => $request->phone_number,
                'role_name'     => $request->role_name,
                'department'    => $dep,
                'password'      => Hash::make($request->password),
                'join_date'     => Carbon::now()->toDayDateTimeString(),
                'status'        => 'Active',
            ]);

                ActivityLog::createLog(
                    'Create',
                    'User',
                    Str::upper($request->name_blood),
                    'Menambahkan Blood : ' . Str::upper($request->name_blood)
                );


            Toastr::success('Blood successfully saved.', 'Success');
            return redirect()->back();
        } catch (\Exception $e) {
            \Log::error($e); // Log the error
            Toastr::error('Failed to save Blood', 'Error');
            return redirect()->back();
        }
    }
 
}
