<?php

namespace App\Http\Controllers;

use DB;
use Carbon\Carbon;
use Midtrans\Snap;
use Midtrans\Config;
use App\Models\Voucer;
use App\Mail\SendEmail;
use App\Models\Country;
use App\Models\Peserta;
use App\Models\Tiket;
use App\Models\Provinsi;
use App\Models\Kabupaten;
use App\Models\Lokasi_run;
use App\Models\company_event;
use Midtrans\Notification;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Kategori_peserta;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Support\Facades\Mail;
use SimpleSoftwareIO\QrCode\Facades\QrCode;



class RegistrasiController extends Controller
{
    public function registrasi()
    {
        $trs = Str::random(5).date('ym');
        $kode = 'EJ'.$trs;
        $negara = Country::all();
        $prov = Provinsi::all();
        $kabupatens = Kabupaten::all();
        $ctgry = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id','RMbaT')
                    ->where('harga_tiket.active_harga_tiket',1)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        return view('home.registrasi',compact('negara','prov','kabupatens','ctgry','kode'));
    }

    public function registrasiPree($id)
    {
        $trs = Str::random(15).date('ym');
        $kode = 'EJ'.$trs;
        $kj = $id;
        // $negara = Country::all();
        $negara = DB::table('country_data2')->get();
        $prov = Provinsi::all();
        $kabupatens = Kabupaten::all();
        $ctgry = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$id)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        // $startDate = $ctgr[0]->tgl_tiket_mulai;
        // $endDate = $ctgr->tgl_tiket_selesai;    
        $lok = Lokasi_run::where('active_lokasi_run',1)
                            ->whereIn('kode_lokasi',['BW','KD','MN','SB'])
                            ->where('tiket_buka','>=',date('Y-m-d'))
                            ->where('tiket_tutup','<=',date('Y-m-d'))
                            ->get(); 
        $lokBW = Lokasi_run::where('active_lokasi_run',1)
                            ->where('kode_lokasi','BW')
                            ->where('tiket_buka','>=',date('Y-m-d'))
                            ->where('tiket_tutup','<=',date('Y-m-d'))
                            ->get();      
        
        $lokKD = Lokasi_run::where('active_lokasi_run',1)
                        ->where('kode_lokasi','KD')
                        ->where('tiket_buka','>=',date('Y-m-d'))
                        ->where('tiket_tutup','<=',date('Y-m-d'))
                        ->get(); 
        $lokMN = Lokasi_run::where('active_lokasi_run',1)
                        ->where('kode_lokasi','MN')
                        ->where('tiket_buka','>=',date('Y-m-d'))
                        ->where('tiket_tutup','<=',date('Y-m-d'))
                        ->get(); 
        $lokSB = Lokasi_run::where('active_lokasi_run',1)
                        ->where('kode_lokasi','SB')
                        ->where('tiket_buka','>=',date('Y-m-d'))
                        ->where('tiket_tutup','<=',date('Y-m-d'))
                        ->get();                                                         

        $currentDate = date('Y-m-d');        
        // $showButton = $currentDate >= $lok[0]->tiket_buka && $currentDate <= $lok[0]->tiket_tutup;  
                         
         
        return view('home.registrasiPree',compact('negara','prov','kabupatens','ctgry','kode','kj','lok','lokBW','lokKD','lokMN','lokSB'));
    }

    public function registrasiPresale($id, $ir, $kot)
    {

        
        $kotaMap = [
            'SB' => 'surabaya',
            'NM' => 'madiun',
            'KD' => 'kediri',
        ];
        
        $city = $kotaMap[$kot] ?? null;
        $now = Carbon::now()->format('Y-m-d H:i:s');
    
        $availableTicket = Tiket::where("tgl_tiket_mulai_{$city}", '<=', $now)
                        ->where("tgl_tiket_selesai_{$city}", '>=', $now)
                        ->first();
    
        if (!$availableTicket) {
           
            return redirect('/coming_soon');
        }
        else{
            //cek pre order
            $availableTicketId = $id;

            $Cek_jml_peserta = Peserta::where('lokasi_run', $kot)
                                        ->where('pembayaran', 'Paid')
                                        ->where('category',2)
                                        ->count();
            $quota = Lokasi_run::where('kode_lokasi', $kot)->value('target_peserta_presale');
            $quota_pelajar =  Kategori_peserta::where('kategori_idp',2)->value('katerangan_kp');

            if ($Cek_jml_peserta >= $quota_pelajar) {
                return redirect('/closed');
            }else{
                $trs = Str::random(15).date('ym');
                $kode = 'EJ'.$trs;
                $kj = $id;
                $kd = $ir;
                $v1 = 'non surabaya';
                $tok = $kot;
                // $negara = Country::all();
                $negara = DB::table('country_data2')->get();
                $prov = Provinsi::all();
                $kabupatens = Kabupaten::all();
                $ctgry = DB::table('kat_event')
                            ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                            ->where('kat_event.active_kat_event',1)
                            ->where('tiket_id',$id)
                            ->where('category_event_id',$ir)
                            ->orderBy('nama_kat_event', 'ASC')
                            ->get();
        
                $lok = Lokasi_run::where('active_lokasi_run',1)
                                    // ->whereIn('kode_lokasi',['BW','KD','MN','SB'])
                                    ->where('kode_lokasi',$kot)
                                    ->get(); 
                $pstr_pljr = Peserta::where('category',2)->whereIn('package',['KBch0','q72VN'])->where('pembayaran','Paid')->where('lokasi_run',$kot)->count();

                $pljr = Kategori_peserta::where('kategori_idp',2)->get();     
                // extra kuota
                $pstr_bwi = Peserta::where('category',2)
                            ->whereIn('package',['KBch0','q72VN'])
                            ->where('pembayaran','Paid')
                            ->whereIn('kabupaten',['3506','3571'])
                            ->count();  
                $war_pelajar = Kategori_peserta::where('kategori_idp',2)
                                ->where('war_tiket',1)
                                ->count(); 
            
                }
        }
        return view('home.registrasiPresale',compact('war_pelajar','city','Cek_jml_peserta','negara','prov','kabupatens','ctgry','kode','kj','lok','kd','v1','tok','pljr','pstr_pljr','pstr_bwi'));
        
    }

    public function getKabupatens($provinsiId)
    {
        $kabupatens = Kabupaten::where('provinsi_id', $provinsiId)->get();
        return response()->json($kabupatens);
    }

    public function getItems(Request $request, $id)
    {
        $type = $request->input('type');
        $items = [];

        if ($type == '1') {
            $items = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$id)
                    ->where('harga_tiket.active_harga_tiket',1)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        } elseif ($type == '2') {
            $items = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id','sRkD9')
                    ->whereNotLike('id_kat_event','BSFm4')
                    ->where('harga_tiket.active_harga_tiket',1)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        }elseif ($type == '3') {
            $items = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$id)
                    ->where('harga_tiket.active_harga_tiket',1)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        }elseif ($type == '4') {
            $items = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$id)
                    ->where('kat_event.id_kat_event','BSFm4')
                    ->where('harga_tiket.active_harga_tiket',1)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        }

        return response()->json($items);
    }

    public function getItems2(Request $request, $id, $ir ,$kota)
    {
        $type = $request->input('type');
        $items = [];

        if($kota  != 'SB'){
            if ($type == '1' || $type == '5') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('harga_tiket.active_harga_tiket',1)
                     
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            } elseif ($type == '2') {
                if($id=='M3ys7'){
                    $di = $id;
                }else{
                    $di = 'sRkD9';
                }
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$di)
                        ->where('category_event_id',$ir)
                        ->whereNotLike('id_kat_event','BSFm4')
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }elseif ($type == '3') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }elseif ($type == '4') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('kat_event.id_kat_event','BSFm4')
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }
        }
        else
        {
            if ($type == '1' || $type == '5') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->where('keterangan_tiket', 'like', '%surabaya%')
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            } elseif ($type == '2') {
                if($id=='M3ys7'){
                    $di = $id;
                }else{
                    $di = 'sRkD9';
                }
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$di)
                        ->where('category_event_id',$ir)
                        ->whereNotLike('id_kat_event','BSFm4')
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->where('keterangan_tiket', 'like', '%surabaya%')
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }elseif ($type == '3') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->where('keterangan_tiket', 'like', '%surabaya%')
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }elseif ($type == '4') {
                $items = DB::table('kat_event')
                        ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                        ->where('kat_event.active_kat_event',1)
                        ->where('tiket_id',$id)
                        ->where('category_event_id',$ir)
                        ->where('kat_event.id_kat_event','BSFm4')
                        ->where('harga_tiket.active_harga_tiket',1)
                        ->where('keterangan_tiket', 'like', '%surabaya%')
                        ->orderBy('nama_kat_event', 'ASC')
                        ->get();
            }
        }
        

        return response()->json($items);
    }

    public function getLokasi(Request $request)
    {
        $type = $request->input('type');
        $items = [];

        if ($type == 'surabaya') {
            $items = DB::table('lokasi_run')
                    
                    ->like('lokasi','Surabaya')
      
                    ->get();
        } elseif ($type != 'surabaya') {
            $items = DB::table('lokasi_run')
                   
                    ->like('lokasi','Madiun')
                  
                    ->get();
        }

        return response()->json($items);
    }



    public function saveRegistrasi(Request $request)
    {
      
            $request->validate([
                  
                    'email'=>'required|string',
                    'provinsi' => 'required|string',
                    
                ]);

                try {
                        $lokasi_run = $request->lokasi_run;
                        $ts = ($request->tshirt_size != null) ? $request->tshirt_size : '-';

                        $order = $request->order_id.''.$lokasi_run.''.date('d');

                        if($request->photo <> '') {
                            $photo = $order . '.' . $request->photo->extension();  
                            $request->photo->move(public_path('assets/images/lisensi'), $photo);
            
                            }else{
            
                                $photo = '';
                            }

                        // $photo ='';
                        $pes = new peserta();
                        $pes->fill([
                            'order_id'  => $order,
                            'full_name'   => Str::title($request->full_name),
                            'first_name'  => Str::title($request->first_name),
                            'last_name'   => Str::title($request->last_name),
                            'email'  => $request->email,
                            'phone'  => $request->phone,
                            'bib_name' => $request->bib_name,
                            'dokumen_id' => $request->dokumen_id,
                            'blood_tipe' => $request->blood_tipe,
                            'jenis_kelamin' => $request->jenis_kelamin,
                            'jenis_no_identitas' =>$request->jenis_no_identitas,
                            'tgl_lahir' => $request->tanggal_lahir,
                            'category' => $request->category,
                            'tshirt_size' => $ts,
                            'community' => NULL,
                            'emergency_name' => $request->emergency_name,
                            'telp_emergency'  => $request->telp_emergency,
                            'relationEmergency' => $request->relationEmergency,
                            'package' => $request->package,
                            'lokasi_run' => $lokasi_run,
                            'alamat'    => $request->alamat,
                            'provinsi' => $request->provinsi,
                            'kabupaten' => $request->kabupaten,
                            'negara' => $request->negara,
                            'voucher' => $request->voucher,
                            'price'  => $request->price,
                            'pembayaran'    => $request->pembayaran,
                            'ttd' => Str::title($request->full_name),
                            'lisensi'=>$photo,
                            'konfirmasi_email' => 0,
                            'konfirmasi_kehadiran' => 0,
                            'pembayaran' => 'Pending',
                          
                        ]);
                        $pes->save();

                        $path = public_path('assets/qrcode/'.$order.'.svg');
                        $image = QrCode::format('svg')
                            ->size(500)
                            ->errorCorrection('H')
                            ->generate($order,$path);

                    
                      

                      // Set your Merchant Server Key
                    \Midtrans\Config::$serverKey = config('midtrans.serverKey');
                    // Set to Development/Sandbox Environment (default). Set to true for Production Environment (accept real transaction).
                    // khusus di production

                    // \Midtrans\Config::$isProduction = config('midtrans.isProduction');
                    // // Set sanitization on (default)
                    // \Midtrans\Config::$isSanitized = config('midtrans.isSanitized');
                    // // Set 3DS transaction for credit card to true
                    // \Midtrans\Config::$is3ds = config('midtrans.is3ds');

                    // sampai sini

                    // untuk development
                    \Midtrans\Config::$isProduction = false;
                    // Set sanitization on (default)
                    \Midtrans\Config::$isSanitized = true;
                    // Set 3DS transaction for credit card to true
                    \Midtrans\Config::$is3ds = true;
                    // sampai sini

                    $lok = company_event::where('event_id',$lokasi_run)->get();
                    $lokk = $lok[0]->event_name;
                
                    $params = [
                        'transaction_details' => [
                            'order_id' => $order,
                            'gross_amount' => $request->price,
                        ],
            
                       'item_details' => [
                    [
                        'id'       => '1',
                        'price'    => $request->price,
                        'quantity' => 1,
                        'name'     => $request->package.' - ('.$lokk.')'
                    ]
                    ],
            
                        'billing_address' => [
                            'first_name'   => Str::title($request->first_name),
                            'last_name'    => Str::title($request->last_name),
                            'address'      => $request->alamat,
                            'city'         => $request->kabupaten,
                            'postal_code'  => "",
                            'phone'        => $request->phone,
                            'country_code' => 'IDN'
                        ],
            
                        'customer_details' => [
                        'first_name'       => Str::title($request->first_name),
                        'last_name'        => Str::title($request->last_name),
                        'email'            => $request->email,
                        'phone'            => $request->phone,
            
                        'billing_address'  => [
                            'first_name'   => Str::title($request->first_name),
                            'last_name'    => Str::title($request->last_name),
                            'address'      => $request->alamat,
                            'city'         => $request->kabupaten,
                            'postal_code'  => "",
                            'phone'        => $request->phone,
                            'country_code' => 'IDN',
                        ],
            
                        'shipping_address' => [
                            'first_name'   => Str::title($request->first_name),
                            'last_name'    => Str::title($request->last_name),
                            'address'      =>  $request->alamat,
                        ],
                        ],
            
                    ];
            
                    $snapToken = \Midtrans\Snap::getSnapToken($params);

                    $pes->snap_token = $snapToken;
                    $pes->save();

                    Toastr::success('Pendaftaran Berhasil', 'Success');

                    return redirect()->route('home.preview', $order);
                   
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Pendaftaran Gagal', 'Error');
                    return $e;
                }
   
    }   

    public function registrasiPreview($id)
    {
        $kode = $id;
        $peserta = Peserta::where('order_id',$id)
                    ->join('provinsi','peserta.provinsi','=','provinsi.id_prov')
                    ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
                    ->join('country_data','peserta.negara','=','country_data.id_country')
                    ->join('kat_event','peserta.package','=','kat_event.id_kat_event')
                    ->first();
        return view('home.preview', compact('peserta','kode'));
    }

    public function kirimEmail($id)
    {
        try {
            $peserta = DB::table('peserta')
                                ->join('participant','peserta.category','=','participant.id')
                                ->where('order_id',$id)
                                ->get();

            $lk = company_event::where('event_id',$peserta[0]->lokasi_run)->get();
            $lokasi = $lk[0]->event_name;
           


            $data = [
                'subject' => 'Konfirmasi Pendaftaran '.$lokasi,
                'title' => 'Konfirmasi Pendaftaran',
                'peserta' => $peserta[0]->full_name,
                'invoice' =>$peserta[0]->order_id,
                'price' =>$peserta[0]->price,
                'ukuran' =>$peserta[0]->tshirt_size,
                'bib_name'=>$peserta[0]->bib_name,
                'kategori' =>$peserta[0]->package,
                'lokasi' =>$lokasi,
                'package' => $peserta[0]->package,
                'jenis_kelamin' => $peserta[0]->jenis_kelamin,
                'nama_kategori' => $peserta[0]->participant_name,
                'nama_event' =>$lk[0]->event_name,
                'medsos' =>$lk[0]->medsos,
                'no_telp' =>$lk[0]->no_telp,
               
            ];

            Mail::to($peserta[0]->email)->send(new SendEmail($data));

            Toastr::success('Pendaftaran Berhasil', 'Success');
            return redirect('peserta');
            
        } catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Pendaftaran Gagal', 'Error');
            return $e;
        }
    }

    public function success($id)
    {


        $peser  = Peserta::findOrFail($id);
        $peser->pembayaran = 'Paid'; 
        $peser->update();

        $kode_lok = $peser->lokasi_run;

        $this->kirimEmail($id); 
        return view('home.success', compact('peser','kode_lok'));

        // return view('home.peserta');
    }

    // public function notificationHandler(Request $request)
    // {
    //     $notif = new Notification();

    //       $transaction = $notif->transaction_status;
    //       $type = $notif->payment_type;
    //       $orderId = $notif->order_id;
    //       $fraud = $notif->fraud_status;
    //       $donation = Peserta::findOrFail($orderId);

    //       if ($transaction == 'capture') {

    //         // For credit card transaction, we need to check whether transaction is challenge by FDS or not
    //         if ($type == 'credit_card') {

    //           if($fraud == 'challenge') {
    //             // TODO set payment status in merchant's database to 'Challenge by FDS'
    //             // TODO merchant should decide whether this transaction is authorized or not in MAP
    //             // $donation->addUpdate("Transaction order_id: " . $orderId ." is challenged by FDS");
    //             $donation->setPending();
    //           } else {
    //             // TODO set payment status in merchant's database to 'Success'
    //             // $donation->addUpdate("Transaction order_id: " . $orderId ." successfully captured using " . $type);
    //             $donation->setSuccess();
    //           }

    //         }

    //       } elseif ($transaction == 'settlement') {

    //         // TODO set payment status in merchant's database to 'Settlement'
    //         // $donation->addUpdate("Transaction order_id: " . $orderId ." successfully transfered using " . $type);
    //         $donation->setSuccess();

    //       } elseif($transaction == 'pending'){

    //         // TODO set payment status in merchant's database to 'Pending'
    //         // $donation->addUpdate("Waiting customer to finish transaction order_id: " . $orderId . " using " . $type);
    //         $donation->setPending();

    //       } elseif ($transaction == 'deny') {

    //         // TODO set payment status in merchant's database to 'Failed'
    //         // $donation->addUpdate("Payment using " . $type . " for transaction order_id: " . $orderId . " is Failed.");
    //         $donation->setFailed();

    //       } elseif ($transaction == 'expire') {

    //         // TODO set payment status in merchant's database to 'expire'
    //         // $donation->addUpdate("Payment using " . $type . " for transaction order_id: " . $orderId . " is expired.");
    //         $donation->setExpired();

    //       } elseif ($transaction == 'cancel') {

    //         // TODO set payment status in merchant's database to 'Failed'
    //         // $donation->addUpdate("Payment using " . $type . " for transaction order_id: " . $orderId . " is canceled.");
    //         $donation->setFailed();

    //       }

    // }

    public function notificationHandler(Request $request)
    {
        /**
         * Dapatkan isi notifikasi dari request
         */
        $payload = $request->getContent();

        /**
         * Dapatkan isi dari request payload
         */
        $notification = json_decode($payload);

        /**
         * Ekstrak data notifikasi
         */
        $transaction_status = $notification->transaction_status;
        $payment_type = $notification->payment_type;
        $orderId = $notification->order_id;
        $fraud = $notification->fraud_status;

        /**
         * Cari data transaksi (no_transactin) berdasarkan orderId dari request
         *
         */
        $data = Peserta::where('order_id', $orderId)->first();

        /**
         * Perbarui status pesanan berdasarkan status yang didapat dari callback
         */
        if ($transaction_status == 'capture') {
            if ($payment_type == 'credit_card') {
                if ($fraud == 'challenge') {
                    $data->update([
                        'pembayaran' => 'pending'
                    ]);
                } else {
                    $data->update([
                        'pembayaran' => 'settlement'
                    ]);
                }
            }
        } elseif ($transaction_status == 'settlement') {
            $data->update([
                'pembayaran' => 'settlement'
            ]);
        } elseif ($transaction_status == 'pending') {
            $data->update([
                'pembayaran' => 'pending'
            ]);
        } elseif ($transaction_status == 'deny') {
            $data->update([
                'pembayaran' => 'denied'
            ]);
        } elseif ($transaction_status == 'settlement') {
            $data->update([
                'pembayaran' => 'settlement'
            ]);
        } elseif ($transaction_status == 'expire') {
            $data->update([
                'pembayaran' => 'expired'
            ]);
        } elseif ($transaction_status == 'cancel') {
            $data->update([
                'pembayaran' => 'canceled'
            ]);
        }
    }

    public function verify($id)
    {
        $certificate = Peserta::find($id);

        if ($certificate) {
            return view('certificates.verify', compact('certificate'));
        } else {
            return view('certificates.notfound');
        }
    }

    public function generateQr($id)
    {
        try{
            $path = public_path('assets/qrcode/'.$id.'.png');
            $image = QrCode::format('png')
                ->merge(public_path('assets/images/EJRF-Logo-bulat.png'), 0.3, true)
                ->size(500)
                ->errorCorrection('H')
                ->generate($id,$path);
             
                
                return $image;

        }catch (\Exception $e) {
            \Log::error($e);
            Toastr::error('Pendaftaran Gagal', 'Error');
            return $e;
        }
       
    }

    public function registrasiPresaleKomunitas($id, $ir, $kot)
    {
        $trs = Str::random(15).date('ym');
        $kode = 'EJ'.$trs;
        $kj = $id;
        $kd = $ir;
        $v1 = 'non surabaya';
        $tok = $kot;
        // $negara = Country::all();
        $negara = DB::table('country_data2')->get();
        $prov = Provinsi::all();
        $kabupatens = Kabupaten::all();
        $ctgry = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$id)
                    ->where('category_event_id',$ir)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
  
        $lok = Lokasi_run::where('active_lokasi_run',1)
                            ->where('kode_lokasi',$kot)
                            ->get(); 
                         
         
        return view('home.registrasiPresaleKomunitas',compact('negara','prov','kabupatens','ctgry','kode','kj','lok','kd','v1','tok'));
    }
    
    public function saveRegistrasikomunitas(Request $request)
    {
      
        
        
                try {
                    $id = $request->kd;
                    $voc = $request->kj;
                    $pay = $request->tok;
                  
                    \Midtrans\Config::$serverKey = config('midtrans.serverKey');
                    \Midtrans\Config::$isProduction = false;
                    // Set sanitization on (default)
                    \Midtrans\Config::$isSanitized = true;
                    // Set 3DS transaction for credit card to true
                    \Midtrans\Config::$is3ds = true;

                    $params = [
                        'transaction_details' => [
                            'order_id' => $id,
                            'gross_amount' => $pay,
                        ],
            
                       'item_details' => [
                    [
                        'id'       => '1',
                        'price'    => $pay,
                        'quantity' => 1,
                        'name'     => $voc,
                    ]
                    ],
            
                        'billing_address' => [
                            'first_name'   => Str::title($voc),
                            'last_name'    => '-',
                            'address'      => '-',
                            'city'         => '-',
                            'postal_code'  => '-',
                            'phone'        => '-',
                            'country_code' => 'IDN'
                        ],
            
                        
            
                    ];
            
                   

                    $snapToken = \Midtrans\Snap::getSnapToken($params);

                    $pes = Peserta::find($id);
                    $pes->snap_token = $snapToken;
                    $pes->save();
                    
                       

                        


                    Toastr::success('Pendaftaran Berhasil', 'Success');

                    return redirect()->route('registrasiKomunitasPreview', ['id' => $id, 'kode' => $voc, 'pay' => $pay]);
                   
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Pendaftaran Gagal', 'Error');
                    return $e;
                }
    }   

    public function saveRegistrasikomunitas1(Request $request)
    {
      
            $request->validate([
                  
                    'email'=>'required|string',
                    'provinsi' => 'required|string',
                    
                ]);
        
                try {
                  
                    $lokasi_run = $request->lokasi_run2;
                     
                    if($lokasi_run == 'surabaya')
                    {
                        $lokasi_run = 'SB';
                    }elseif($lokasi_run == 'non surabaya')
                    {
                        $lokasi_run = 'AL2';
                    }elseif($lokasi_run == 'Include Surabaya')
                    {
                        $lokasi_run = 'AL';
                    }elseif($lokasi_run == 'Banyuwangi')
                    {
                        $lokasi_run = 'BW';
                    }elseif($lokasi_run == 'Kediri')
                    {
                        $lokasi_run = 'KD';
                    }else{
                        $lokas_run = $lokasi_run;
                    }
                       
                    
                        $pes = new Peserta();

                  


                        if($request->package == 'BSFm4')
                        {
                            $kategori = 'HM';
                        }elseif($request->package == 'ELyx4')
                        {
                            $kategori = 'FUN WALK';
                        }elseif($request->package == 'KBch0')
                        {
                            $kategori = '5K';
                        }elseif($request->package == 'MLqi4')
                        {
                            $kategori = '400M';
                        }elseif($request->package == 'ptBPk')
                        {
                            $kategori = '200M';
                        }else{
                            $kategori = '10K';
                        }

                        $order = $request->order_id.''.$lokasi_run.''.date('d');

                        if($request->photo <> '') {
                            $photo = $order . '.' . $request->photo->extension();  
                            $request->photo->move(public_path('assets/images/lisensi'), $photo);
            
                            }else{
            
                                $photo = '';
                            }

                        // $photo ='';

                        $pes->fill([
                            'order_id'  => $order,
                            'full_name'   => Str::title($request->full_name),
                            'first_name'  => Str::title($request->first_name),
                            'last_name'   => Str::title($request->last_name),
                            'email'  => $request->email,
                            'phone'  => $request->phone,
                            'bib_name' => $request->bib_name,
                            'dokumen_id' => $request->dokumen_id,
                            'blood_tipe' => $request->blood_tipe,
                            'jenis_kelamin' => $request->jenis_kelamin,
                            'tgl_lahir' => $request->tgl_lahir,
                            'category' => $request->category,
                            'tshirt_size' => $request->tshirt_size,
                            'community' => $request->community,
                            'emergency_name' => $request->emergency_name,
                            'telp_emergency'  => $request->telp_emergency,
                            'relationEmergency' => $request->relationEmergency,
                            'package' => $request->package,
                            'lokasi_run' => $lokasi_run,
                            'alamat'    => $request->alamat,
                            'provinsi' => $request->provinsi,
                            'kabupaten' => $request->kabupaten,
                            'negara' => $request->negara,
                            'voucher' => $request->voucher,
                            'price'  => $request->price,
                            'pembayaran'    => $request->pembayaran,
                            'ttd' => $request->ttd,
                            'lisensi'=>$photo,
                            'konfirmasi_email' => 0,
                            'konfirmasi_kehadiran' => 0,
                            'pembayaran' => 'Pending',
                          
                        ]);
                        $pes->save();

                        // $path = public_path('assets/qrcode/'.$order.'.png');
                        // $image = QrCode::format('png')
                        //     ->merge(public_path('assets/images/EJRF-Logo-bulat.png'), 0.3, true)
                        //     ->size(500)
                        //     ->errorCorrection('H')
                        //     ->generate($order,$path);

                        
                    Toastr::success('Pendaftaran Berhasil', 'Success');

                    return redirect()->route('listKomunitas', $request->voucher);
                   
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Pendaftaran Gagal', 'Error');
                    return $e;
                }
    }  
    

    public function cekVoucer(Request $request)
    {

                try {
                  
                    $certificate = Voucer::find($request->voucer);


                    // Toastr::success('Pendaftaran Berhasil', 'Success');

                    // return redirect()->route('registrasiPreview', $order);

                    if ($certificate) {
                        $k = $request->voucer;
                        $v = $certificate->kota_voucer;
                        $qty = $certificate->anggota;
                        $dis = $certificate->diskon;
                      
                        $reg = 'RMbaT';
                        $tk = 'q72VN';
                        $fk = 'KBch0';
                        $pesertas = Peserta::join('kat_event','peserta.package','=','kat_event.id_kat_event')
                                    ->where('voucher', $k)
                                    ->orderBy('full_name', 'ASC')
                                    ->get();
                        $total_peserta = $pesertas->count();     
                        $jumlah_bayar = $pesertas->sum('price');      

                        

                        Toastr::success('Pendaftaran Berhasil', 'Success');
                        // return view('home.listkomunitas', compact('k','pesertas','v','reg','tk','fk','total_peserta','jumlah_bayar','qty','dis'));
                        return redirect()->route('listKomunitas', $k);
                    } else {
                        Toastr::error('Voucer Tidak Terdaftar', 'Error');
                        return view('home.voucer');
                    }
                   
                } catch (\Exception $e) {
                    \Log::error($e);
                    Toastr::error('Pendaftaran Gagal', 'Error');
                    return $e;
                }
    }

    public function listKomunitas($id)
    {
        $reget = 'RMbaT';
        $tk = 'q72VN';
        $fk = 'KBch0';
        $hm = 'BSFm4';

        $certificate = Voucer::find($id);

        $k = $id;
        $v = $certificate->kota_voucer;
        $qty = $certificate->anggota;
        $dis = $certificate->diskon;

        $pesertas = Peserta::join('kat_event','peserta.package','=','kat_event.id_kat_event')
                        ->where('voucher', $id)
                        ->orderBy('full_name', 'ASC')
                        ->get();
        $total_peserta = $pesertas->count();     
        $jumlah_bayar = $pesertas->sum('price');  
        $or_id = $pesertas->where('snap_token',NULL)->first();             
        $id_or = $or_id ? $or_id->order_id : null;

        $diskon1 = $pesertas->where('category','!==',2)->sum('price');
        if($total_peserta >=$qty){
            $diskon = $diskon1 ? $diskon1 * ($dis/100) : 0;
        }else{
            $diskon = 0;
        }
        

        $total = $jumlah_bayar - $diskon;

      

        $snapTokenExists = $pesertas->contains(function($peserta) {
            return !is_null($peserta->snap_token);
        });

        return view('home.listKomunitas', compact( 'pesertas','reget','tk','fk','hm','k','v','qty','dis','total_peserta','jumlah_bayar','id_or' ,'snapTokenExists','diskon','total' ));
    }

    public function registrasiKomunitas($kodes,$kd,$kota,$voucher)
    {
        $trs = Str::random(15).date('ym');
        $kode = 'EJ'.$trs;
        $kj = $kodes;
        $kd = $kd;
        $v1 = 'surabaya';
        $tok = $kota;
        $voc = $voucher;
        $vc = Voucer::find($voucher);
        $kma = $vc->nama_voucer;
        // $negara = Country::all();
        $negara = DB::table('country_data2')->get();
        $prov = Provinsi::all();
        $kabupatens = Kabupaten::all();
        $ctgry = DB::table('kat_event')
                    ->join('harga_tiket','kat_event.id_kat_event','=','harga_tiket.category_event_id')
                    ->where('kat_event.active_kat_event',1)
                    ->where('tiket_id',$kodes)
                    ->where('category_event_id',$kd)
                    ->orderBy('nama_kat_event', 'ASC')
                    ->get();
        $pstr_bwi = Peserta::where('category',2)
                    ->whereIn('package',['KBch0','q72VN'])
                    ->where('pembayaran','Paid')
                    ->whereIn('kabupaten',['3506','3571'])
                    ->count();  
  
        $lok = Lokasi_run::where('active_lokasi_run',1)
                            ->where('kode_lokasi',$kota)
                            ->get(); 
        $war_pelajar = Kategori_peserta::where('kategori_idp',2)
                        ->where('war_tiket',1)
                        ->count();                     
                            
        $pstr_pljr = Peserta::where('category',2)->whereIn('package',['KBch0','q72VN'])->where('pembayaran','Paid')->where('lokasi_run',$kota)->count();

        $pljr = Kategori_peserta::where('kategori_idp',2)->get();
                         
         
        return view('home.registrasikomunitas',compact('war_pelajar','pstr_bwi','pstr_pljr','pljr','negara','prov','kabupatens','ctgry','kode','kj','lok','kd','v1','tok','voc','kma'));
    }

    

    public function registrasiKomunitasPreview($id,$voc,$pay)

    {


        


        $kode = $id;
        $py = $pay;
        $peserta = Peserta::where('order_id',$id)
                    ->join('provinsi','peserta.provinsi','=','provinsi.id_prov')
                    ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
                    ->join('country_data','peserta.negara','=','country_data.id_country')
                    ->join('kat_event','peserta.package','=','kat_event.id_kat_event')
                    ->first();

        return view('home.komunitasPreview', compact('peserta','kode','py'));
    }
}
