<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class QRCodeController extends Controller
{
    public function index(Request $request)
    {
        $path = public_path('assets/qrcode/1.png');
        $image = QrCode::format('png')
            ->merge(public_path('assets/images/EJRF-Logo-bulat.png'), 0.3, true)
            ->size(500)
            ->errorCorrection('H')
            ->generate('EJ5T7Z32412EJ5T7Z32412',$path);

        // return response($image)->header('Content-type','image/png');
    }
}
