<?php

namespace App\Http\Controllers;

use Midtrans\Config;
use App\Models\Peserta;
use Midtrans\Notification;
use Illuminate\Http\Request;
use App\Http\Controllers\RegistrasiController;

class PaymentController extends Controller
{
    public function handleNotification(Request $request)
    {
        // Set konfigurasi Midtrans
        Config::$serverKey = env('MIDTRANS_SERVER_KEY');
        Config::$isProduction = env('MIDTRANS_IS_PRODUCTION', false);
        Config::$isSanitized = true;
        Config::$is3ds = true;

        // Inisialisasi notifikasi
        $notification = new Notification();

        // Ambil status dan transaksi terkait
        $order_id = $notification->order_id;
        $status = $notification->transaction_status;
        $payment_type = $notification->payment_type;
        $fraud_status = $notification->fraud_status;

        // Temukan order berdasarkan order_id
        $order = Peserta::where('order_id', $order_id)->first();

        if (!$order) {
            // Order tidak ditemukan
            return response()->json(['message' => 'Order not found'], 404);
        }

        // Periksa status transaksi dan perbarui status order
        switch ($status) {
            case 'capture':
                if ($payment_type == 'credit_card' && $fraud_status == 'challenge') {
                    // Status transaksi credit card challenge
                    $order->pembayaran = 'pending';
                } else {
                    // Transaksi berhasil
                    $order->pembayaran = 'paid';
                }
                break;
            case 'settlement':
                // Pembayaran berhasil
                $order->pembayaran = 'paid';
                
                break;
            case 'pending':
                // Pembayaran dalam status pending
                $order->pembayaran = 'pending';
                break;
            case 'deny':
                // Pembayaran ditolak
                $order->pembayaran = 'failed';
                break;
            case 'expired':
                // Pembayaran kadaluarsa
                $order->pembayaran = 'expired';
                break;
            case 'cancel':
                // Pembayaran dibatalkan
                $order->pembayaran = 'cancelled';
                break;
        }

        // Simpan status order yang sudah diperbarui
        $order->save();

        if($status == 'settlement'){
            $kirim = RegistrasiController::kirimEmail($order_id);
            return $kirim;
        }

        // Berikan response sukses agar Midtrans tahu bahwa notifikasi telah diterima
        return response()->json(['message' => 'Notification received successfully']);
    }
}
