<?php

namespace App\Http\Controllers;

use Midtrans\Config;
use App\Models\Peserta;
use Midtrans\Notification;
use Illuminate\Http\Request;

class MidtransController extends Controller
{
    public function __construct()
    {
        // Konfigurasi Midtrans
        Config::$serverKey = config('midtrans.server_key');
        Config::$clientKey = config('midtrans.client_key');
        Config::$isProduction = config('midtrans.is_production');
        Config::$isSanitized = true;
        Config::$is3ds = true;
    }
    public function callback(Request $request)
    {
        $notification = new Notification();

        // Ambil data notifikasi
        $orderId = $notification->order_id;
        $status = $notification->transaction_status;
        $fraudStatus = $notification->fraud_status;

        // Temukan pesanan berdasarkan order_id
        $order = Peserta::where('order_id', $orderId)->first();

        if (!$order) {
            return response()->json(['error' => 'Order not found'], 404);
        }

        // Proses status transaksi
        switch ($status) {
            case 'capture':
                // Pembayaran berhasil dan berhasil diverifikasi
                if ($fraudStatus == 'accept') {
                    $order->pembayaran = 'paid';
                    $order->save();
                } else {
                    // Status fraud
                    $order->pembayaran = 'fraud';
                    $order->save();
                }
                break;

            case 'settlement':
                // Pembayaran berhasil
                $order->pembayaran = 'paid';
                $order->save();
                break;

            case 'pending':
                // Pembayaran sedang dalam proses
                $order->pembayaran = 'pending';
                $order->save();
                break;

            case 'deny':
                // Pembayaran ditolak
                $order->pembayaran = 'failed';
                $order->save();
                break;

            case 'expire':
                // Pembayaran kedaluwarsa
                $order->pembayaran = 'expired';
                $order->save();
                break;

            case 'cancel':
                // Pembayaran dibatalkan
                $order->pembayaran = 'cancelled';
                $order->save();
                break;
        }

        return response()->json(['status' => 'success']);
    }

}
