<?php

namespace App\Exports;

use DB;
use App\Models\Peserta;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class PesertaExportSB implements FromCollection, WithHeadings, WithMapping, WithColumnFormatting
{
    protected $userId;
    /**
    * @return \Illuminate\Support\Collection
    */

    public function __construct($userId)
    {
        $this->userId = $userId;
    }

    public function collection()
    {
        // return Peserta::where('lokasi_run',$this->userId)->get(["bib_number","order_id","full_name","first_name","last_name","email","phone","bib_name","dokumen_id","blood_tipe","jenis_kelamin","tgl_lahir","tshirt_size","community","emergency_name","telp_emergency","relationEmergency","package","lokasi_run","alamat","kabupaten","negara","voucher","pembayaran","updated_at","price"]);
       $pes = DB::table('peserta')
                ->join('kabupatens','peserta.kabupaten','=','kabupatens.id')
                ->join('kat_event','peserta.package','=','kat_event.id_kat_event')
                ->join('kategori_peserta','peserta.category','=','kategori_peserta.kategori_idp')
                ->where('pembayaran','Paid')
             
                ->whereIn('lokasi_run',['SB','AL'])
                ->get(["bib_number","order_id","full_name","first_name","last_name","email","phone","bib_name","dokumen_id","blood_tipe","jenis_kelamin","tgl_lahir","tshirt_size","community","emergency_name","telp_emergency","relationEmergency","nama_kat_event","lokasi_run","alamat","nama","negara","voucher","pembayaran","price",'nama_kategori']);

        return $pes;    
    }

    public function headings(): array
    {
        return ["bibNumber","orderId", "fullName","firstName","lastName","email","phone","bibName","documentId","bloodType","sex","dob","tShirtSize","community","nameEmergency","phoneEmergency","relationEmergency","category","lokasi","address","name","nationality","voucherCode","pay","nominal","Category"];
    }
    public function map($peserta): array
    {
        return [
            $peserta->bib_number,
            $peserta->order_id,
            $peserta->full_name,
            $peserta->first_name,
            $peserta->last_name,
            $peserta->email,
            "`" . strval($peserta->phone),
            $peserta->bib_name,
            "`" . strval($peserta->dokumen_id), // Paksa jadi string dengan apostrof di awal
            $peserta->blood_tipe,
            $peserta->jenis_kelamin,
            $peserta->tgl_lahir,
            $peserta->tshirt_size,
            $peserta->community,
            $peserta->emergency_name,
            $peserta->telp_emergency,
            $peserta->relationEmergency,
            $peserta->nama_kat_event,
            $peserta->lokasi_run,
            $peserta->alamat,
            $peserta->nama,
            $peserta->negara,
            $peserta->voucher,
            $peserta->pembayaran,
            $peserta->price,
            $peserta->nama_kategori,
        ];
    }

    public function columnFormats(): array
    {
        return [
            'I' => NumberFormat::FORMAT_TEXT, // Kolom I (dokumen_id) diformat sebagai teks
            'G' => NumberFormat::FORMAT_TEXT, // Kolom I (dokumen_id) diformat sebagai teks
        ];
    }

}
